/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc;

import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.jdbc.impl.JDBCClientImpl;
import io.vertx.ext.jdbc.spi.DataSourceProvider;
import io.vertx.ext.sql.SQLClient;
import java.util.UUID;
import javax.sql.DataSource;

@VertxGen
public interface JDBCClient
extends SQLClient {
    public static final String DEFAULT_PROVIDER_CLASS = "io.vertx.ext.jdbc.spi.impl.C3P0DataSourceProvider";
    public static final String DEFAULT_DS_NAME = "DEFAULT_DS";

    public static JDBCClient create(Vertx vertx, JsonObject config) {
        return new JDBCClientImpl(vertx, config, UUID.randomUUID().toString());
    }

    public static JDBCClient createShared(Vertx vertx, JsonObject config, String dataSourceName) {
        return new JDBCClientImpl(vertx, config, dataSourceName);
    }

    public static JDBCClient createShared(Vertx vertx, JsonObject config) {
        return new JDBCClientImpl(vertx, config, DEFAULT_DS_NAME);
    }

    @GenIgnore
    public static JDBCClient create(Vertx vertx, DataSource dataSource) {
        return new JDBCClientImpl(vertx, dataSource);
    }

    @GenIgnore
    public static JDBCClient create(Vertx vertx, DataSourceProvider dataSourceProvider) {
        return new JDBCClientImpl(vertx, dataSourceProvider);
    }
}

