/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.JsonArray;
import io.vertx.core.spi.metrics.PoolMetrics;
import io.vertx.ext.jdbc.impl.actions.AbstractJDBCAction;
import io.vertx.ext.jdbc.impl.actions.JDBCAutoCommit;
import io.vertx.ext.jdbc.impl.actions.JDBCBatch;
import io.vertx.ext.jdbc.impl.actions.JDBCCallable;
import io.vertx.ext.jdbc.impl.actions.JDBCClose;
import io.vertx.ext.jdbc.impl.actions.JDBCCommit;
import io.vertx.ext.jdbc.impl.actions.JDBCExecute;
import io.vertx.ext.jdbc.impl.actions.JDBCQuery;
import io.vertx.ext.jdbc.impl.actions.JDBCRollback;
import io.vertx.ext.jdbc.impl.actions.JDBCStatementHelper;
import io.vertx.ext.jdbc.impl.actions.JDBCUpdate;
import io.vertx.ext.jdbc.impl.actions.StreamQuery;
import io.vertx.ext.sql.ResultSet;
import io.vertx.ext.sql.SQLConnection;
import io.vertx.ext.sql.SQLOptions;
import io.vertx.ext.sql.SQLRowStream;
import io.vertx.ext.sql.TransactionIsolation;
import io.vertx.ext.sql.UpdateResult;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class JDBCConnectionImpl
implements SQLConnection {
    private static final Logger log = LoggerFactory.getLogger(JDBCConnectionImpl.class);
    private final Connection conn;
    private final ContextInternal ctx;
    private final PoolMetrics metrics;
    private final Object metric;
    private final JDBCStatementHelper helper;
    private SQLOptions options;

    public JDBCConnectionImpl(Context context, JDBCStatementHelper helper, Connection conn, PoolMetrics metrics, Object metric) {
        this.helper = helper;
        this.conn = conn;
        this.metrics = metrics;
        this.metric = metric;
        this.ctx = (ContextInternal)context;
    }

    @Override
    public synchronized SQLConnection setOptions(SQLOptions options) {
        this.options = options;
        return this;
    }

    private synchronized SQLOptions getOptions() {
        return this.options;
    }

    @Override
    public SQLConnection setAutoCommit(boolean autoCommit, Handler<AsyncResult<Void>> resultHandler) {
        this.schedule(new JDBCAutoCommit(this.getOptions(), autoCommit)).onComplete(resultHandler);
        return this;
    }

    @Override
    public SQLConnection execute(String sql, Handler<AsyncResult<Void>> resultHandler) {
        this.schedule(new JDBCExecute(this.getOptions(), sql)).onComplete(resultHandler);
        return this;
    }

    @Override
    public SQLConnection query(String sql, Handler<AsyncResult<ResultSet>> resultHandler) {
        this.schedule(new JDBCQuery(this.helper, this.getOptions(), sql, null)).onComplete(resultHandler);
        return this;
    }

    @Override
    public SQLConnection queryStream(String sql, Handler<AsyncResult<SQLRowStream>> handler) {
        this.schedule(new StreamQuery(this.helper, this.getOptions(), this.ctx, sql, null)).onComplete(handler);
        return this;
    }

    @Override
    public SQLConnection queryStreamWithParams(String sql, JsonArray params, Handler<AsyncResult<SQLRowStream>> handler) {
        this.schedule(new StreamQuery(this.helper, this.getOptions(), this.ctx, sql, params)).onComplete(handler);
        return this;
    }

    @Override
    public SQLConnection queryWithParams(String sql, JsonArray params, Handler<AsyncResult<ResultSet>> resultHandler) {
        this.schedule(new JDBCQuery(this.helper, this.getOptions(), sql, params)).onComplete(resultHandler);
        return this;
    }

    @Override
    public SQLConnection update(String sql, Handler<AsyncResult<UpdateResult>> resultHandler) {
        this.schedule(new JDBCUpdate(this.helper, this.getOptions(), sql, null)).onComplete(resultHandler);
        return this;
    }

    @Override
    public SQLConnection updateWithParams(String sql, JsonArray params, Handler<AsyncResult<UpdateResult>> resultHandler) {
        this.schedule(new JDBCUpdate(this.helper, this.getOptions(), sql, params)).onComplete(resultHandler);
        return this;
    }

    @Override
    public SQLConnection call(String sql, Handler<AsyncResult<ResultSet>> resultHandler) {
        this.schedule(new JDBCCallable(this.helper, this.getOptions(), sql, null, null)).onComplete(resultHandler);
        return this;
    }

    @Override
    public SQLConnection callWithParams(String sql, JsonArray params, JsonArray outputs, Handler<AsyncResult<ResultSet>> resultHandler) {
        this.schedule(new JDBCCallable(this.helper, this.getOptions(), sql, params, outputs)).onComplete(resultHandler);
        return this;
    }

    @Override
    public void close(Handler<AsyncResult<Void>> handler) {
        this.schedule(new JDBCClose(this.getOptions(), this.metrics, this.metric)).onComplete(handler);
    }

    @Override
    public void close() {
        this.close((Handler<AsyncResult<Void>>)((Handler)ar -> {
            if (ar.failed()) {
                log.error((Object)"Failure in closing connection", ar.cause());
            }
        }));
    }

    @Override
    public SQLConnection commit(Handler<AsyncResult<Void>> handler) {
        this.schedule(new JDBCCommit(this.getOptions())).onComplete(handler);
        return this;
    }

    @Override
    public SQLConnection rollback(Handler<AsyncResult<Void>> handler) {
        this.schedule(new JDBCRollback(this.getOptions())).onComplete(handler);
        return this;
    }

    @Override
    public SQLConnection getTransactionIsolation(Handler<AsyncResult<TransactionIsolation>> handler) {
        this.ctx.executeBlocking(f -> {
            try {
                TransactionIsolation txIsolation = TransactionIsolation.from(this.conn.getTransactionIsolation());
                if (txIsolation != null) {
                    f.complete((Object)txIsolation);
                } else {
                    f.fail("Unknown isolation level");
                }
            }
            catch (SQLException e) {
                f.fail((Throwable)e);
            }
        }, handler);
        return this;
    }

    @Override
    public SQLConnection batch(List<String> sqlStatements, Handler<AsyncResult<List<Integer>>> handler) {
        this.schedule(new JDBCBatch(this.helper, this.getOptions(), sqlStatements)).onComplete(handler);
        return this;
    }

    @Override
    public SQLConnection batchWithParams(String statement, List<JsonArray> args, Handler<AsyncResult<List<Integer>>> handler) {
        this.schedule(new JDBCBatch(this.helper, this.getOptions(), statement, args)).onComplete(handler);
        return this;
    }

    @Override
    public SQLConnection batchCallableWithParams(String statement, List<JsonArray> inArgs, List<JsonArray> outArgs, Handler<AsyncResult<List<Integer>>> handler) {
        this.schedule(new JDBCBatch(this.helper, this.getOptions(), statement, inArgs, outArgs)).onComplete(handler);
        return this;
    }

    @Override
    public SQLConnection setTransactionIsolation(TransactionIsolation isolation, Handler<AsyncResult<Void>> handler) {
        this.ctx.executeBlocking(f -> {
            try {
                this.conn.setTransactionIsolation(isolation.getType());
                f.complete(null);
            }
            catch (SQLException e) {
                f.fail((Throwable)e);
            }
        }, handler);
        return this;
    }

    public <C> C unwrap() {
        return (C)this.conn;
    }

    public <T> Future<T> schedule(AbstractJDBCAction<T> action) {
        SQLOptions sqlOptions = this.getOptions();
        return this.ctx.executeBlocking(promise -> {
            try {
                JDBCConnectionImpl.applyConnectionOptions(this.conn, sqlOptions);
                Object result = action.execute(this.conn);
                promise.complete(result);
            }
            catch (SQLException e) {
                promise.fail((Throwable)e);
            }
        });
    }

    private static void applyConnectionOptions(Connection conn, SQLOptions sqlOptions) throws SQLException {
        if (sqlOptions != null) {
            if (sqlOptions.isReadOnly()) {
                conn.setReadOnly(true);
            }
            if (sqlOptions.getCatalog() != null) {
                conn.setCatalog(sqlOptions.getCatalog());
            }
            if (sqlOptions.getSchema() != null) {
                conn.setSchema(sqlOptions.getSchema());
            }
        }
    }
}

