/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpcio.server.impl;

import com.google.protobuf.Descriptors;
import io.grpc.Attributes;
import io.grpc.Compressor;
import io.grpc.CompressorRegistry;
import io.grpc.Context;
import io.grpc.Decompressor;
import io.grpc.DecompressorRegistry;
import io.grpc.Grpc;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import io.grpc.Status;
import io.grpc.protobuf.ProtoServiceDescriptorSupplier;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.net.SocketAddress;
import io.vertx.grpc.common.GrpcError;
import io.vertx.grpc.common.GrpcMessageEncoder;
import io.vertx.grpc.common.GrpcStatus;
import io.vertx.grpc.common.GrpcWriteStream;
import io.vertx.grpc.common.ServiceName;
import io.vertx.grpc.common.impl.VertxScheduledExecutorService;
import io.vertx.grpc.common.impl.WriteStreamAdapter;
import io.vertx.grpc.server.GrpcServerRequest;
import io.vertx.grpc.server.GrpcServerResponse;
import io.vertx.grpc.server.impl.GrpcServerResponseImpl;
import io.vertx.grpcio.common.impl.BridgeMessageDecoder;
import io.vertx.grpcio.common.impl.BridgeMessageEncoder;
import io.vertx.grpcio.common.impl.ReadStreamAdapter;
import io.vertx.grpcio.common.impl.Utils;
import io.vertx.grpcio.server.GrpcIoServer;
import io.vertx.grpcio.server.GrpcIoServiceBridge;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class GrpcIoServiceBridgeImpl
implements GrpcIoServiceBridge {
    private final ServiceName serviceName;
    private final ServerServiceDefinition serviceDef;
    private final ProtoServiceDescriptorSupplier protoServiceDescriptorSupplier;

    public GrpcIoServiceBridgeImpl(ServerServiceDefinition serviceDef) {
        Object schemaDesc = serviceDef.getServiceDescriptor().getSchemaDescriptor();
        if (!(schemaDesc instanceof ProtoServiceDescriptorSupplier)) {
            throw new IllegalArgumentException("Service definition must be a ProtoMethodDescriptorSupplier");
        }
        ProtoServiceDescriptorSupplier supplier = (ProtoServiceDescriptorSupplier)schemaDesc;
        if (supplier.getFileDescriptor() == null) {
            throw new IllegalArgumentException("Service definition must have a FileDescriptor");
        }
        this.protoServiceDescriptorSupplier = supplier;
        this.serviceName = ServiceName.create((String)serviceDef.getServiceDescriptor().getName());
        this.serviceDef = serviceDef;
    }

    public ServiceName name() {
        return this.serviceName;
    }

    public Descriptors.ServiceDescriptor descriptor() {
        return this.protoServiceDescriptorSupplier.getServiceDescriptor();
    }

    @Override
    public void unbind(GrpcIoServer server) {
        this.serviceDef.getMethods().forEach(m -> this.unbind(server, (ServerMethodDefinition)m));
    }

    private <Req, Resp> void unbind(GrpcIoServer server, ServerMethodDefinition<Req, Resp> methodDef) {
        server.callHandler(methodDef.getMethodDescriptor(), null);
    }

    @Override
    public void bind(GrpcIoServer server) {
        this.serviceDef.getMethods().forEach(m -> this.bind(server, (ServerMethodDefinition)m));
    }

    private <Req, Resp> void bind(GrpcIoServer server, ServerMethodDefinition<Req, Resp> methodDef) {
        server.callHandler(methodDef.getMethodDescriptor(), req -> {
            ServerCallHandler callHandler = methodDef.getServerCallHandler();
            Context context = Context.current();
            if (req.timeout() > 0L) {
                Context.CancellableContext cancellable = context.withDeadlineAfter(req.timeout(), TimeUnit.MILLISECONDS, (ScheduledExecutorService)new VertxScheduledExecutorService(Vertx.currentContext()));
                context = cancellable;
                context.addListener(context1 -> ((GrpcServerResponseImpl)req.response()).handleTimeout(), new Executor(){

                    @Override
                    public void execute(Runnable command) {
                        command.run();
                    }
                });
            }
            Context theContext = context;
            Runnable task = theContext.wrap(() -> {
                ServerCallImpl call = new ServerCallImpl(theContext, req, methodDef);
                ServerCall.Listener listener = callHandler.startCall(call, Utils.readMetadata((MultiMap)req.headers()));
                call.init(listener);
            });
            task.run();
        });
    }

    private static class ServerCallImpl<Req, Resp>
    extends ServerCall<Req, Resp> {
        private final Context context;
        private final GrpcServerRequest<Req, Resp> req;
        private final ServerMethodDefinition<Req, Resp> methodDef;
        private final ReadStreamAdapter<Req> readAdapter;
        private final WriteStreamAdapter<Resp> writeAdapter;
        private ServerCall.Listener<Req> listener;
        private final Decompressor decompressor;
        private Compressor compressor;
        private boolean halfClosed;
        private boolean closed;
        private int messagesSent;
        private final Attributes attributes;

        public ServerCallImpl(final Context context, GrpcServerRequest<Req, Resp> req, ServerMethodDefinition<Req, Resp> methodDef) {
            String encoding = req.encoding();
            this.context = context;
            this.decompressor = DecompressorRegistry.getDefaultInstance().lookupDecompressor(encoding);
            this.req = req;
            this.methodDef = methodDef;
            this.readAdapter = new ReadStreamAdapter<Req>(){

                protected void handleClose() {
                    halfClosed = true;
                    Context previous = context.attach();
                    try {
                        listener.onHalfClose();
                    }
                    finally {
                        context.detach(previous);
                    }
                }

                protected void handleMessage(Req msg) {
                    if (!closed) {
                        Context previous = context.attach();
                        try {
                            listener.onMessage(msg);
                        }
                        finally {
                            context.detach(previous);
                        }
                    }
                }
            };
            this.writeAdapter = new WriteStreamAdapter<Resp>(){

                protected void handleReady() {
                    Context previous = context.attach();
                    try {
                        listener.onReady();
                    }
                    finally {
                        context.detach(previous);
                    }
                }
            };
            this.attributes = this.createAttributes();
        }

        void init(ServerCall.Listener<Req> listener) {
            this.listener = listener;
            this.req.errorHandler(error -> {
                if (error == GrpcError.CANCELLED && !this.closed) {
                    listener.onCancel();
                }
            });
            this.readAdapter.init(this.req, new BridgeMessageDecoder(this.methodDef.getMethodDescriptor().getRequestMarshaller(), this.decompressor));
            this.writeAdapter.init((GrpcWriteStream)this.req.response(), this.req.format(), (GrpcMessageEncoder)new BridgeMessageEncoder(this.methodDef.getMethodDescriptor().getResponseMarshaller(), this.compressor));
        }

        private Attributes createAttributes() {
            SocketAddress localAddr;
            Attributes.Builder builder = Attributes.newBuilder();
            SocketAddress remoteAddr = this.req.connection().remoteAddress();
            if (remoteAddr != null && remoteAddr.isInetSocket()) {
                try {
                    InetAddress address = InetAddress.getByName(remoteAddr.hostAddress());
                    builder.set(Grpc.TRANSPORT_ATTR_REMOTE_ADDR, (Object)new InetSocketAddress(address, remoteAddr.port()));
                }
                catch (UnknownHostException address) {
                    // empty catch block
                }
            }
            if ((localAddr = this.req.connection().localAddress()) != null && localAddr.isInetSocket()) {
                try {
                    InetAddress address = InetAddress.getByName(localAddr.hostAddress());
                    builder.set(Grpc.TRANSPORT_ATTR_LOCAL_ADDR, (Object)new InetSocketAddress(address, localAddr.port()));
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
            if (this.req.connection().isSsl()) {
                builder.set(Grpc.TRANSPORT_ATTR_SSL_SESSION, (Object)this.req.connection().sslSession());
            }
            return builder.build();
        }

        public boolean isReady() {
            return this.writeAdapter.isReady();
        }

        public void request(int numMessages) {
            this.readAdapter.request(numMessages);
        }

        public void sendHeaders(Metadata headers) {
            GrpcServerResponse response = this.req.response();
            Utils.writeMetadata((Metadata)headers, (MultiMap)response.headers());
            response.writeHead();
        }

        public void sendMessage(Resp message) {
            ++this.messagesSent;
            this.writeAdapter.write(message);
        }

        public void close(Status status, Metadata trailers) {
            if (this.closed) {
                throw new IllegalStateException("Already closed");
            }
            this.closed = true;
            this.readAdapter.request(Integer.MAX_VALUE);
            GrpcServerResponse response = this.req.response();
            if (status == Status.OK && this.methodDef.getMethodDescriptor().getType().serverSendsOneMessage() && this.messagesSent == 0) {
                response.status(GrpcStatus.UNAVAILABLE).end();
            } else {
                Utils.writeMetadata((Metadata)trailers, (MultiMap)response.trailers());
                response.status(GrpcStatus.valueOf((int)status.getCode().value()));
                response.statusMessage(status.getDescription());
                response.end();
            }
            this.listener.onComplete();
        }

        public boolean isCancelled() {
            return false;
        }

        public MethodDescriptor<Req, Resp> getMethodDescriptor() {
            return this.methodDef.getMethodDescriptor();
        }

        public void setCompression(String encoding) {
            this.compressor = CompressorRegistry.getDefaultInstance().lookupCompressor(encoding);
            GrpcServerResponse response = this.req.response();
            if (response.acceptedEncodings().contains(encoding)) {
                response.encoding(encoding);
            }
        }

        public void setMessageCompression(boolean enabled) {
            super.setMessageCompression(enabled);
        }

        public Attributes getAttributes() {
            return this.attributes;
        }
    }
}

