/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpcio.server.impl.stub;

import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.CallStreamObserver;
import io.grpc.stub.ServerCallStreamObserver;
import io.grpc.stub.StreamObserver;
import io.vertx.core.Completable;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import io.vertx.grpcio.common.impl.stub.GrpcWriteStream;
import io.vertx.grpcio.common.impl.stub.StreamObserverReadStream;
import java.util.function.BiConsumer;

public final class ServerCalls {
    private ServerCalls() {
    }

    public static <I, O> void oneToOne(ContextInternal ctx, I request, StreamObserver<O> response, String compression, BiConsumer<I, Completable<O>> delegate) {
        ServerCalls.trySetCompression(response, compression);
        try {
            delegate.accept(request, (res, err) -> {
                if (err == null) {
                    response.onNext(res);
                    response.onCompleted();
                } else {
                    response.onError(ServerCalls.prepareError(err));
                }
            });
        }
        catch (Throwable throwable) {
            response.onError(ServerCalls.prepareError(throwable));
        }
    }

    public static <I, O> void oneToMany(ContextInternal ctx, I request, StreamObserver<O> response, String compression, BiConsumer<I, WriteStream<O>> delegate) {
        ServerCalls.trySetCompression(response, compression);
        try {
            GrpcWriteStream responseWriteStream = new GrpcWriteStream(ctx, response);
            delegate.accept(request, (WriteStream<O>)responseWriteStream);
        }
        catch (Throwable throwable) {
            response.onError(ServerCalls.prepareError(throwable));
        }
    }

    public static <I, O> StreamObserver<I> manyToOne(ContextInternal ctx, StreamObserver<O> response, String compression, BiConsumer<ReadStream<I>, Completable<O>> delegate) {
        ServerCalls.trySetCompression(response, compression);
        StreamObserverReadStream request = new StreamObserverReadStream(ctx, (CallStreamObserver)response);
        request.init();
        Completable completable = (res, err) -> {
            if (err == null) {
                response.onNext(res);
                response.onCompleted();
            } else {
                response.onError(ServerCalls.prepareError(err));
            }
        };
        try {
            delegate.accept((ReadStream<I>)request, (Completable<O>)completable);
        }
        catch (Throwable throwable) {
            response.onError(ServerCalls.prepareError(throwable));
            return request;
        }
        return request;
    }

    public static <I, O> StreamObserver<I> manyToMany(ContextInternal ctx, StreamObserver<O> response, String compression, BiConsumer<ReadStream<I>, WriteStream<O>> delegate) {
        ServerCalls.trySetCompression(response, compression);
        StreamObserverReadStream request = new StreamObserverReadStream(ctx, (CallStreamObserver)response);
        request.init();
        GrpcWriteStream responseStream = new GrpcWriteStream(ctx, response);
        try {
            delegate.accept((ReadStream<I>)request, (WriteStream<O>)responseStream);
        }
        catch (Throwable throwable) {
            response.onError(ServerCalls.prepareError(throwable));
        }
        return request;
    }

    private static void trySetCompression(StreamObserver<?> response, String compression) {
        if (compression != null && response instanceof ServerCallStreamObserver) {
            ServerCallStreamObserver serverResponse = (ServerCallStreamObserver)response;
            serverResponse.setCompression(compression);
        }
    }

    private static Throwable prepareError(Throwable throwable) {
        if (throwable instanceof io.vertx.grpc.server.StatusException) {
            return new StatusRuntimeException(Status.fromCode((Status.Code)Status.Code.valueOf((String)((io.vertx.grpc.server.StatusException)throwable).status().name())));
        }
        if (throwable instanceof UnsupportedOperationException) {
            return new StatusRuntimeException(Status.UNIMPLEMENTED);
        }
        if (throwable instanceof StatusException || throwable instanceof StatusRuntimeException) {
            return throwable;
        }
        return Status.fromThrowable((Throwable)throwable).asException();
    }
}

