/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpcio.common.impl;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.grpc.InternalMetadata;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.netty.util.AsciiString;
import io.vertx.core.MultiMap;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class Utils {
    public static void writeMetadata(Metadata metadata, MultiMap mmap) {
        byte[][] array = InternalMetadata.serialize((Metadata)metadata);
        for (int i = 0; i < array.length; i += 2) {
            AsciiString key = new AsciiString(array[i], false);
            AsciiString value = key.endsWith((CharSequence)"-bin") ? new AsciiString(Base64.getEncoder().encode(array[i + 1]), false) : new AsciiString(array[i + 1], false);
            mmap.add((CharSequence)key, (CharSequence)value);
        }
    }

    public static Metadata readMetadata(MultiMap headers) {
        List entries = headers.entries();
        byte[][] array = new byte[entries.size() * 2][];
        int idx = 0;
        for (Map.Entry entry : entries) {
            String key = ((String)entry.getKey()).toLowerCase(Locale.ROOT);
            array[idx++] = key.getBytes(StandardCharsets.UTF_8);
            String value = (String)entry.getValue();
            byte[] data = key.endsWith("-bin") ? Base64.getDecoder().decode(value) : value.getBytes(StandardCharsets.UTF_8);
            array[idx++] = data;
        }
        return InternalMetadata.newMetadata((byte[][])array);
    }

    public static <T extends MessageOrBuilder> MethodDescriptor.Marshaller<T> marshallerFor(final Supplier<Message.Builder> b) {
        return new MethodDescriptor.PrototypeMarshaller<T>(){

            @Nullable
            public T getMessagePrototype() {
                Message.Builder builder = (Message.Builder)b.get();
                return builder.build();
            }

            public Class<T> getMessageClass() {
                throw new UnsupportedOperationException();
            }

            public InputStream stream(T value) {
                String res;
                try {
                    res = JsonFormat.printer().print(value);
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RuntimeException(e);
                }
                return new ByteArrayInputStream(res.getBytes(StandardCharsets.UTF_8));
            }

            public T parse(InputStream stream) {
                try {
                    Message.Builder builder = (Message.Builder)b.get();
                    byte[] bytes = stream.readAllBytes();
                    JsonFormat.parser().merge(new String(bytes, StandardCharsets.UTF_8), builder);
                    return builder.build();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }
}

