/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpcio.common.impl;

import io.grpc.Compressor;
import io.grpc.Drainable;
import io.grpc.MethodDescriptor;
import io.vertx.core.buffer.Buffer;
import io.vertx.grpc.common.GrpcMessage;
import io.vertx.grpc.common.GrpcMessageEncoder;
import io.vertx.grpc.common.WireFormat;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BridgeMessageEncoder<T>
implements GrpcMessageEncoder<T> {
    private MethodDescriptor.Marshaller<T> marshaller;
    private Compressor compressor;

    public BridgeMessageEncoder(MethodDescriptor.Marshaller<T> marshaller, Compressor compressor) {
        this.marshaller = marshaller;
        this.compressor = compressor;
    }

    public WireFormat format() {
        return WireFormat.PROTOBUF;
    }

    public GrpcMessage encode(final T msg) {
        return new GrpcMessage(){
            private Buffer encoded;

            public String encoding() {
                return BridgeMessageEncoder.this.compressor == null ? "identity" : BridgeMessageEncoder.this.compressor.getMessageEncoding();
            }

            public WireFormat format() {
                return WireFormat.PROTOBUF;
            }

            public Buffer payload() {
                if (this.encoded == null) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    try (InputStream is = BridgeMessageEncoder.this.marshaller.stream(msg);){
                        OutputStream compressingStream = BridgeMessageEncoder.this.compressor == null ? baos : BridgeMessageEncoder.this.compressor.compress((OutputStream)baos);
                        try (ByteArrayOutputStream o = compressingStream;){
                            if (is instanceof Drainable) {
                                Drainable stream = (Drainable)is;
                                stream.drainTo(compressingStream);
                            } else {
                                int len;
                                byte[] tmp = new byte[1024];
                                while ((len = is.read(tmp)) != -1) {
                                    ((OutputStream)o).write(tmp, 0, len);
                                }
                            }
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    byte[] bytes = baos.toByteArray();
                    this.encoded = Buffer.buffer((byte[])bytes);
                }
                return this.encoded;
            }
        };
    }
}

