/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpcio.common.impl;

import io.grpc.Decompressor;
import io.grpc.MethodDescriptor;
import io.vertx.grpc.common.GrpcMessage;
import io.vertx.grpc.common.GrpcMessageDecoder;
import io.vertx.grpc.common.WireFormat;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BridgeMessageDecoder<T>
implements GrpcMessageDecoder<T> {
    private MethodDescriptor.Marshaller<T> marshaller;
    private Decompressor decompressor;

    public BridgeMessageDecoder(MethodDescriptor.Marshaller<T> marshaller, Decompressor decompressor) {
        this.marshaller = marshaller;
        this.decompressor = decompressor;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T decode(GrpcMessage msg) {
        if (msg.encoding().equals("identity")) {
            return (T)this.marshaller.parse((InputStream)new ByteArrayInputStream(msg.payload().getBytes()));
        }
        try (InputStream in = this.decompressor.decompress((InputStream)new ByteArrayInputStream(msg.payload().getBytes()));){
            Object object = this.marshaller.parse(in);
            return (T)object;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public WireFormat format() {
        return WireFormat.PROTOBUF;
    }
}

