/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpcio.client;

import io.grpc.MethodDescriptor;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.net.Address;
import io.vertx.grpc.client.GrpcClient;
import io.vertx.grpc.client.GrpcClientBuilder;
import io.vertx.grpc.client.GrpcClientOptions;
import io.vertx.grpc.client.GrpcClientRequest;
import io.vertx.grpc.client.GrpcClientResponse;
import io.vertx.grpcio.client.impl.GrpcIoClientBuilder;
import io.vertx.grpcio.client.impl.GrpcIoClientImpl;
import java.util.function.Function;

@VertxGen
public interface GrpcIoClient
extends GrpcClient {
    public static GrpcClientBuilder<GrpcIoClient> builder(Vertx vertx) {
        return new GrpcIoClientBuilder(vertx);
    }

    public static GrpcIoClient client(Vertx vertx) {
        return (GrpcIoClient)GrpcIoClient.builder(vertx).build();
    }

    public static GrpcIoClient client(Vertx vertx, GrpcClientOptions options) {
        return (GrpcIoClient)GrpcIoClient.builder(vertx).with(options).build();
    }

    public static GrpcIoClient client(Vertx vertx, GrpcClientOptions grpcOptions, HttpClientOptions httpOptions) {
        return (GrpcIoClient)GrpcIoClient.builder(vertx).with(grpcOptions).with(httpOptions).build();
    }

    public static GrpcIoClient client(Vertx vertx, HttpClientOptions options) {
        return (GrpcIoClient)GrpcIoClient.builder(vertx).with(options).build();
    }

    public static GrpcIoClient client(Vertx vertx, HttpClient client) {
        return new GrpcIoClientImpl(vertx, client);
    }

    @GenIgnore(value={"permitted-type"})
    public <Req, Resp> Future<GrpcClientRequest<Req, Resp>> request(Address var1, MethodDescriptor<Req, Resp> var2);

    @GenIgnore(value={"permitted-type"})
    public <Req, Resp> Future<GrpcClientRequest<Req, Resp>> request(MethodDescriptor<Req, Resp> var1);

    @GenIgnore(value={"permitted-type"})
    default public <Req, Resp, T> Future<T> call(Address server, MethodDescriptor<Req, Resp> service, Handler<GrpcClientRequest<Req, Resp>> requestHandler, Function<GrpcClientResponse<Req, Resp>, Future<T>> resultFn) {
        return this.request(server, service).compose(req -> {
            requestHandler.handle(req);
            return req.response().compose(resultFn);
        });
    }

    @GenIgnore(value={"permitted-type"})
    default public <Req, Resp, T> Future<T> call(MethodDescriptor<Req, Resp> service, Handler<GrpcClientRequest<Req, Resp>> requestHandler, Function<GrpcClientResponse<Req, Resp>, Future<T>> resultFn) {
        return this.request(service).compose(req -> {
            requestHandler.handle(req);
            return req.response().compose(resultFn);
        });
    }
}

