/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpcio.client.impl;

import io.grpc.MethodDescriptor;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.net.Address;
import io.vertx.grpc.client.GrpcClientOptions;
import io.vertx.grpc.client.GrpcClientRequest;
import io.vertx.grpc.client.impl.GrpcClientImpl;
import io.vertx.grpc.common.GrpcMessageDecoder;
import io.vertx.grpc.common.GrpcMessageEncoder;
import io.vertx.grpc.common.ServiceMethod;
import io.vertx.grpc.common.ServiceName;
import io.vertx.grpcio.client.GrpcIoClient;
import io.vertx.grpcio.common.impl.BridgeMessageDecoder;
import io.vertx.grpcio.common.impl.BridgeMessageEncoder;

public class GrpcIoClientImpl
extends GrpcClientImpl
implements GrpcIoClient {
    public GrpcIoClientImpl(Vertx vertx, HttpClient client) {
        super(vertx, client);
    }

    public GrpcIoClientImpl(Vertx vertx, GrpcClientOptions grpcOptions, HttpClient client, boolean close) {
        super(vertx, grpcOptions, client, close);
    }

    @Override
    public <Req, Resp> Future<GrpcClientRequest<Req, Resp>> request(MethodDescriptor<Req, Resp> service) {
        BridgeMessageDecoder messageDecoder = new BridgeMessageDecoder(service.getResponseMarshaller(), null);
        BridgeMessageEncoder messageEncoder = new BridgeMessageEncoder(service.getRequestMarshaller(), null);
        ServiceMethod serviceMethod = ServiceMethod.client((ServiceName)ServiceName.create((String)service.getServiceName()), (String)service.getBareMethodName(), (GrpcMessageEncoder)messageEncoder, (GrpcMessageDecoder)messageDecoder);
        return this.request(serviceMethod);
    }

    @Override
    public <Req, Resp> Future<GrpcClientRequest<Req, Resp>> request(Address server, MethodDescriptor<Req, Resp> service) {
        BridgeMessageDecoder messageDecoder = new BridgeMessageDecoder(service.getResponseMarshaller(), null);
        BridgeMessageEncoder messageEncoder = new BridgeMessageEncoder(service.getRequestMarshaller(), null);
        ServiceMethod serviceMethod = ServiceMethod.client((ServiceName)ServiceName.create((String)service.getServiceName()), (String)service.getBareMethodName(), (GrpcMessageEncoder)messageEncoder, (GrpcMessageDecoder)messageDecoder);
        return this.request(server, serviceMethod);
    }
}

