/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.impl;

import io.grpc.stub.StreamObserver;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.streams.WriteStream;
import io.vertx.grpc.GrpcReadStream;
import io.vertx.grpc.GrpcUniExchange;
import io.vertx.grpc.GrpcWriteStream;
import java.util.concurrent.atomic.AtomicBoolean;

public class GrpcUniExchangeImpl<O, I>
implements GrpcUniExchange<O, I> {
    private final GrpcWriteStream<O> writeStream;
    private final AtomicBoolean complete = new AtomicBoolean();
    private Handler<AsyncResult<I>> handler;

    public GrpcUniExchangeImpl(GrpcReadStream<I> readStream, StreamObserver<O> writeObserver) {
        this.writeStream = GrpcWriteStream.create(writeObserver);
        readStream.endHandler(v -> {
            if (this.complete.compareAndSet(false, true) && this.handler != null) {
                this.handler.handle((Object)Future.succeededFuture());
            }
        });
        readStream.handler(input -> {
            if (this.complete.compareAndSet(false, true) && this.handler != null) {
                this.handler.handle((Object)Future.succeededFuture((Object)input));
            }
        });
        readStream.exceptionHandler(t -> {
            if (this.complete.compareAndSet(false, true) && this.handler != null) {
                this.handler.handle((Object)Future.failedFuture((Throwable)t));
            }
        });
    }

    public GrpcUniExchange<O, I> exceptionHandler(Handler<Throwable> handler) {
        throw new RuntimeException("Unsupported Operation");
    }

    @Override
    public GrpcUniExchange<O, I> handler(Handler<AsyncResult<I>> handler) {
        this.handler = handler;
        return this;
    }

    @Override
    public GrpcUniExchange<O, I> write(O data) {
        this.writeStream.write((Object)data);
        return this;
    }

    public WriteStream<O> write(O data, Handler<AsyncResult<Void>> handler) {
        this.writeStream.write(data, handler);
        return this;
    }

    public void end() {
        this.writeStream.end();
    }

    public void end(Handler<AsyncResult<Void>> handler) {
        this.writeStream.end(handler);
    }

    @Override
    public GrpcUniExchange<O, I> setWriteQueueMaxSize(int maxSize) {
        this.writeStream.setWriteQueueMaxSize(maxSize);
        return this;
    }

    public boolean writeQueueFull() {
        return this.writeStream.writeQueueFull();
    }

    @Override
    public GrpcUniExchange<O, I> drainHandler(Handler<Void> handler) {
        this.writeStream.drainHandler((Handler)handler);
        return this;
    }

    @Override
    public GrpcUniExchange<O, I> fail(Throwable t) {
        this.writeStream.fail(t);
        return this;
    }

    @Override
    public StreamObserver<O> writeObserver() {
        return this.writeStream.writeObserver();
    }
}

