/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.server.impl;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.base64.Base64;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.buffer.BufferInternal;
import io.vertx.grpc.common.GrpcMessageEncoder;
import io.vertx.grpc.server.GrpcProtocol;
import io.vertx.grpc.server.impl.GrpcServerRequestImpl;
import io.vertx.grpc.server.impl.GrpcServerResponseImpl;
import java.util.Map;

public class WebGrpcServerResponse<Req, Resp>
extends GrpcServerResponseImpl<Req, Resp> {
    private final GrpcProtocol protocol;
    private final HttpServerResponse httpResponse;
    private Buffer trailers;

    public WebGrpcServerResponse(ContextInternal context, GrpcServerRequestImpl<Req, Resp> request, GrpcProtocol protocol, HttpServerResponse httpResponse, GrpcMessageEncoder<Resp> encoder) {
        super(context, request, protocol, httpResponse, encoder);
        this.protocol = protocol;
        this.httpResponse = httpResponse;
    }

    private void appendToTrailers(MultiMap entries) {
        if (this.trailers == null) {
            this.trailers = Buffer.buffer();
        }
        for (Map.Entry trailer : entries) {
            this.trailers.appendString((String)trailer.getKey()).appendByte((byte)58).appendString((String)trailer.getValue()).appendString("\r\n");
        }
    }

    @Override
    protected Buffer encodeMessage(Buffer message, boolean compressed, boolean trailer) {
        message = super.encodeMessage(message, compressed, trailer);
        if (this.protocol == GrpcProtocol.WEB_TEXT) {
            message = BufferInternal.buffer((ByteBuf)Base64.encode((ByteBuf)((BufferInternal)message).getByteBuf(), (boolean)false));
        }
        return message;
    }

    @Override
    protected void setHeaders(String contentType, MultiMap grpcHeaders) {
        this.httpResponse.setChunked(!this.isTrailersOnly());
        super.setHeaders(contentType, grpcHeaders);
    }

    @Override
    protected void setTrailers(MultiMap grpcTrailers) {
        if (this.isTrailersOnly()) {
            if (grpcTrailers != null) {
                this.encodeGrpcTrailers(grpcTrailers, this.httpResponse.headers());
            }
        } else {
            MultiMap buffer = HttpHeaders.headers();
            super.encodeGrpcStatus(buffer);
            this.appendToTrailers(buffer);
            if (grpcTrailers != null) {
                this.appendToTrailers(grpcTrailers);
            }
        }
    }

    @Override
    protected Future<Void> sendEnd() {
        if (this.trailers != null) {
            Future ret = this.httpResponse.end(this.encodeMessage(this.trailers, false, true));
            this.trailers = null;
            return ret;
        }
        return this.httpResponse.end();
    }
}

