/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.server;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.json.JsonObject;
import io.vertx.grpc.server.GrpcProtocol;
import io.vertx.grpc.server.GrpcServerOptionsConverter;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;

@DataObject
@JsonGen(publicConverter=false)
public class GrpcServerOptions {
    public static final Set<GrpcProtocol> DEFAULT_ENABLED_PROTOCOLS = Collections.unmodifiableSet(EnumSet.allOf(GrpcProtocol.class));
    public static final boolean DEFAULT_SCHEDULE_DEADLINE_AUTOMATICALLY = false;
    public static final boolean DEFAULT_PROPAGATE_DEADLINE = false;
    public static final long DEFAULT_MAX_MESSAGE_SIZE = 262144L;
    private Set<GrpcProtocol> enabledProtocols;
    private boolean scheduleDeadlineAutomatically;
    private boolean deadlinePropagation;
    private long maxMessageSize;

    public GrpcServerOptions() {
        this.enabledProtocols = EnumSet.copyOf(DEFAULT_ENABLED_PROTOCOLS);
        this.scheduleDeadlineAutomatically = false;
        this.deadlinePropagation = false;
        this.maxMessageSize = 262144L;
    }

    public GrpcServerOptions(GrpcServerOptions other) {
        this.enabledProtocols = EnumSet.copyOf(other.enabledProtocols);
        this.scheduleDeadlineAutomatically = other.scheduleDeadlineAutomatically;
        this.deadlinePropagation = other.deadlinePropagation;
        this.maxMessageSize = other.maxMessageSize;
    }

    public GrpcServerOptions(JsonObject json) {
        this();
        GrpcServerOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public boolean isProtocolEnabled(GrpcProtocol protocol) {
        return this.enabledProtocols.contains((Object)protocol);
    }

    public GrpcServerOptions addEnabledProtocol(GrpcProtocol protocol) {
        this.enabledProtocols.add(protocol);
        return this;
    }

    public GrpcServerOptions removeEnabledProtocol(GrpcProtocol protocol) {
        this.enabledProtocols.remove((Object)protocol);
        return this;
    }

    public Set<GrpcProtocol> getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public boolean getScheduleDeadlineAutomatically() {
        return this.scheduleDeadlineAutomatically;
    }

    public GrpcServerOptions setScheduleDeadlineAutomatically(boolean scheduleDeadlineAutomatically) {
        this.scheduleDeadlineAutomatically = scheduleDeadlineAutomatically;
        return this;
    }

    public boolean getDeadlinePropagation() {
        return this.deadlinePropagation;
    }

    public GrpcServerOptions setDeadlinePropagation(boolean deadlinePropagation) {
        this.deadlinePropagation = deadlinePropagation;
        return this;
    }

    public long getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public GrpcServerOptions setMaxMessageSize(long maxMessageSize) {
        if (maxMessageSize <= 0L) {
            throw new IllegalArgumentException("Max message size must be > 0");
        }
        if (maxMessageSize > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Max message size must be <= 0xFFFFFFFF");
        }
        this.maxMessageSize = maxMessageSize;
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        GrpcServerOptionsConverter.toJson(this, json);
        return json;
    }

    public String toString() {
        return this.toJson().encode();
    }
}

