/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.server.impl;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.base64.Base64;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.buffer.BufferInternal;
import io.vertx.core.streams.WriteStream;
import io.vertx.grpc.common.GrpcError;
import io.vertx.grpc.common.GrpcMessageEncoder;
import io.vertx.grpc.common.GrpcStatus;
import io.vertx.grpc.common.impl.GrpcMessageImpl;
import io.vertx.grpc.common.impl.GrpcWriteStreamBase;
import io.vertx.grpc.common.impl.Utils;
import io.vertx.grpc.server.GrpcProtocol;
import io.vertx.grpc.server.GrpcServerResponse;
import io.vertx.grpc.server.impl.GrpcServerRequestImpl;
import java.util.Map;
import java.util.Objects;

public class GrpcServerResponseImpl<Req, Resp>
extends GrpcWriteStreamBase<GrpcServerResponseImpl<Req, Resp>, Resp>
implements GrpcServerResponse<Req, Resp> {
    private final GrpcServerRequestImpl<Req, Resp> request;
    private final HttpServerResponse httpResponse;
    private final GrpcProtocol protocol;
    private GrpcStatus status = GrpcStatus.OK;
    private String statusMessage;
    private MultiMap httpResponseTrailers;
    private boolean trailersOnly;
    private boolean cancelled;

    public GrpcServerResponseImpl(ContextInternal context, GrpcServerRequestImpl<Req, Resp> request, GrpcProtocol protocol, HttpServerResponse httpResponse, GrpcMessageEncoder<Resp> encoder) {
        super(context, protocol.mediaType(), (WriteStream)httpResponse, encoder);
        this.request = request;
        this.httpResponse = httpResponse;
        this.protocol = protocol;
    }

    @Override
    public GrpcServerResponse<Req, Resp> status(GrpcStatus status) {
        Objects.requireNonNull(status);
        this.status = status;
        return this;
    }

    @Override
    public GrpcServerResponse<Req, Resp> statusMessage(String msg) {
        this.statusMessage = msg;
        return this;
    }

    public void handleTimeout() {
        if (!this.isCancelled()) {
            if (!this.isTrailersSent()) {
                this.status(GrpcStatus.DEADLINE_EXCEEDED);
                this.end();
            } else {
                this.cancel();
            }
        }
    }

    public void cancel() {
        if (this.cancelled) {
            return;
        }
        this.cancelled = true;
        Future fut = this.request.end();
        if (fut.failed()) {
            return;
        }
        boolean requestEnded = fut.succeeded();
        if (!(requestEnded && this.isTrailersSent() || !this.httpResponse.reset(GrpcError.CANCELLED.http2ResetCode))) {
            this.handleError(GrpcError.CANCELLED);
        }
    }

    protected void sendHeaders(String contentType, MultiMap headers, boolean end) {
        MultiMap responseHeaders = this.httpResponse.headers();
        this.trailersOnly = this.status != GrpcStatus.OK && end;
        this.httpResponse.setChunked(this.protocol.isWeb() && !this.trailersOnly);
        if (headers != null && !headers.isEmpty()) {
            for (Map.Entry header : headers) {
                responseHeaders.add((String)header.getKey(), (String)header.getValue());
            }
        }
        responseHeaders.set("content-type", contentType);
        if (!this.protocol.isWeb()) {
            responseHeaders.set("grpc-encoding", this.encoding);
            responseHeaders.set("grpc-accept-encoding", "gzip");
        }
    }

    protected void sendTrailers(MultiMap trailers) {
        this.httpResponseTrailers = this.trailersOnly ? this.httpResponse.headers() : (!this.protocol.isWeb() ? this.httpResponse.trailers() : HttpHeaders.headers());
        MultiMap responseHeaders = this.httpResponse.headers();
        if (trailers != null && !trailers.isEmpty()) {
            for (Map.Entry trailer : trailers) {
                this.httpResponseTrailers.add((String)trailer.getKey(), (String)trailer.getValue());
            }
        }
        if (!responseHeaders.contains("grpc-status")) {
            this.httpResponseTrailers.set("grpc-status", this.status.toString());
        }
        if (this.status != GrpcStatus.OK) {
            String msg = this.statusMessage;
            if (msg != null && !responseHeaders.contains("grpc-status-message")) {
                this.httpResponseTrailers.set("grpc-message", Utils.utf8PercentEncode((String)msg));
            }
        } else {
            this.httpResponseTrailers.remove("grpc-message");
        }
        if (this.protocol.isWeb() && !this.trailersOnly) {
            Buffer buffer = Buffer.buffer();
            for (Map.Entry trailer : this.httpResponseTrailers) {
                buffer.appendString((String)trailer.getKey()).appendByte((byte)58).appendString((String)trailer.getValue()).appendString("\r\n");
            }
            this.httpResponse.write((Object)this.encodeMessage(buffer, false, true));
        }
    }

    protected Future<Void> sendMessage(Buffer message, boolean compressed) {
        return this.httpResponse.write((Object)this.encodeMessage(message, compressed, false));
    }

    protected Future<Void> sendEnd() {
        this.request.cancelTimeout();
        return this.httpResponse.end();
    }

    private Buffer encodeMessage(Buffer message, boolean compressed, boolean trailer) {
        BufferInternal buffer = GrpcMessageImpl.encode((Buffer)message, (boolean)compressed, (boolean)trailer);
        if (this.protocol == GrpcProtocol.WEB_TEXT) {
            return BufferInternal.buffer((ByteBuf)Base64.encode((ByteBuf)buffer.getByteBuf(), (boolean)false));
        }
        return buffer;
    }
}

