/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.server;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.json.JsonObject;
import io.vertx.grpc.server.GrpcServerOptionsConverter;
import java.util.Map;

@DataObject
@JsonGen(publicConverter=false)
public class GrpcServerOptions {
    public static final long DEFAULT_MAX_MESSAGE_SIZE = 262144L;
    private long maxMessageSize = 262144L;

    public GrpcServerOptions() {
    }

    public GrpcServerOptions(GrpcServerOptions options) {
        this.maxMessageSize = options.maxMessageSize;
    }

    public GrpcServerOptions(JsonObject json) {
        GrpcServerOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public long getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public GrpcServerOptions setMaxMessageSize(long maxMessageSize) {
        if (maxMessageSize <= 0L) {
            throw new IllegalArgumentException("Max message size must be > 0");
        }
        if (maxMessageSize > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Max message size must be <= 0xFFFFFFFF");
        }
        this.maxMessageSize = maxMessageSize;
        return this;
    }
}

