/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.server.impl;

import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.impl.HttpServerRequestInternal;
import io.vertx.core.streams.ReadStream;
import io.vertx.grpc.common.CodecException;
import io.vertx.grpc.common.GrpcMessage;
import io.vertx.grpc.common.GrpcMessageDecoder;
import io.vertx.grpc.common.GrpcMessageEncoder;
import io.vertx.grpc.common.ServiceName;
import io.vertx.grpc.common.impl.GrpcMethodCall;
import io.vertx.grpc.common.impl.GrpcReadStreamBase;
import io.vertx.grpc.server.GrpcServerRequest;
import io.vertx.grpc.server.GrpcServerResponse;
import io.vertx.grpc.server.impl.GrpcServerResponseImpl;

public class GrpcServerRequestImpl<Req, Resp>
extends GrpcReadStreamBase<GrpcServerRequestImpl<Req, Resp>, Req>
implements GrpcServerRequest<Req, Resp> {
    final HttpServerRequest httpRequest;
    final GrpcServerResponse<Req, Resp> response;
    private GrpcMessageDecoder<Req> messageDecoder;
    private GrpcMethodCall methodCall;

    public GrpcServerRequestImpl(HttpServerRequest httpRequest, GrpcMessageDecoder<Req> messageDecoder, GrpcMessageEncoder<Resp> messageEncoder, GrpcMethodCall methodCall) {
        super(((HttpServerRequestInternal)httpRequest).context(), (ReadStream)httpRequest, httpRequest.headers().get("grpc-encoding"));
        this.httpRequest = httpRequest;
        this.response = new GrpcServerResponseImpl(httpRequest.response(), messageEncoder);
        this.methodCall = methodCall;
        this.messageDecoder = messageDecoder;
    }

    @Override
    public String fullMethodName() {
        return this.methodCall.fullMethodName();
    }

    public MultiMap headers() {
        return this.httpRequest.headers();
    }

    public String encoding() {
        return this.httpRequest.getHeader("grpc-encoding");
    }

    @Override
    public ServiceName serviceName() {
        return this.methodCall.serviceName();
    }

    @Override
    public String methodName() {
        return this.methodCall.methodName();
    }

    @Override
    public GrpcServerRequest<Req, Resp> handler(Handler<Req> handler) {
        if (handler != null) {
            return (GrpcServerRequest)this.messageHandler(msg -> {
                GrpcMessage abc;
                switch (msg.encoding()) {
                    case "identity": {
                        abc = msg;
                        break;
                    }
                    case "gzip": {
                        try {
                            abc = GrpcMessage.message((String)"identity", (Buffer)((Buffer)GrpcMessageDecoder.GZIP.decode(msg)));
                            break;
                        }
                        catch (CodecException e) {
                            this.response.cancel();
                            return;
                        }
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
                Object decoded = this.messageDecoder.decode(abc);
                handler.handle(decoded);
            });
        }
        return (GrpcServerRequest)this.messageHandler(null);
    }

    @Override
    public GrpcServerResponse<Req, Resp> response() {
        return this.response;
    }
}

