/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.reflection;

import com.google.protobuf.Descriptors;
import io.vertx.core.Handler;
import io.vertx.grpc.common.GrpcMessageDecoder;
import io.vertx.grpc.common.GrpcMessageEncoder;
import io.vertx.grpc.common.GrpcStatus;
import io.vertx.grpc.common.ServiceMethod;
import io.vertx.grpc.common.ServiceName;
import io.vertx.grpc.reflection.v1.ErrorResponse;
import io.vertx.grpc.reflection.v1.ExtensionNumberResponse;
import io.vertx.grpc.reflection.v1.ExtensionRequest;
import io.vertx.grpc.reflection.v1.FileDescriptorResponse;
import io.vertx.grpc.reflection.v1.ListServiceResponse;
import io.vertx.grpc.reflection.v1.ServerReflectionRequest;
import io.vertx.grpc.reflection.v1.ServerReflectionResponse;
import io.vertx.grpc.reflection.v1.ServiceResponse;
import io.vertx.grpc.server.GrpcServer;
import io.vertx.grpc.server.GrpcServerRequest;
import io.vertx.grpc.server.GrpcServerResponse;
import io.vertx.grpc.server.Service;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

class GrpcServerReflectionV1Handler
implements Handler<GrpcServerRequest<ServerReflectionRequest, ServerReflectionResponse>> {
    public static final ServiceMethod<ServerReflectionRequest, ServerReflectionResponse> SERVICE_METHOD = ServiceMethod.server((ServiceName)ServiceName.create((String)"grpc.reflection.v1.ServerReflection"), (String)"ServerReflectionInfo", (GrpcMessageEncoder)GrpcMessageEncoder.encoder(), (GrpcMessageDecoder)GrpcMessageDecoder.decoder(ServerReflectionRequest.parser()));
    private final GrpcServer server;

    GrpcServerReflectionV1Handler(GrpcServer server) {
        this.server = server;
    }

    public void handle(GrpcServerRequest<ServerReflectionRequest, ServerReflectionResponse> request) {
        request.handler(serverReflectionRequest -> {
            GrpcServerResponse response = request.response();
            switch (serverReflectionRequest.getMessageRequestCase()) {
                case LIST_SERVICES: {
                    response.end((Object)this.getServiceList((ServerReflectionRequest)serverReflectionRequest));
                    break;
                }
                case FILE_BY_FILENAME: {
                    response.end((Object)this.getFileByName((ServerReflectionRequest)serverReflectionRequest));
                    break;
                }
                case FILE_CONTAINING_SYMBOL: {
                    response.end((Object)this.getFileContainingSymbol((ServerReflectionRequest)serverReflectionRequest));
                    break;
                }
                case FILE_CONTAINING_EXTENSION: {
                    response.end((Object)this.getFileByExtension((ServerReflectionRequest)serverReflectionRequest));
                    break;
                }
                case ALL_EXTENSION_NUMBERS_OF_TYPE: {
                    response.end((Object)this.getAllExtensions((ServerReflectionRequest)serverReflectionRequest));
                    break;
                }
                default: {
                    response.end((Object)this.getErrorResponse((ServerReflectionRequest)serverReflectionRequest, GrpcStatus.UNIMPLEMENTED, "not implemented " + serverReflectionRequest.getMessageRequestCase()));
                }
            }
        });
    }

    private ServerReflectionResponse getServiceList(ServerReflectionRequest request) {
        List serviceNames = this.server.getServices().stream().map(metadata -> metadata.name().fullyQualifiedName()).collect(Collectors.toList());
        ListServiceResponse response = serviceNames.stream().map(s -> ServiceResponse.newBuilder().setName((String)s).build()).collect(ListServiceResponse::newBuilder, ListServiceResponse.Builder::addService, (b1, b2) -> b1.addAllService(b2.getServiceList())).build();
        return ServerReflectionResponse.newBuilder().setValidHost(request.getHost()).setOriginalRequest(request).setListServicesResponse(response).build();
    }

    private ServerReflectionResponse getFileByName(ServerReflectionRequest request) {
        String name = request.getFileByFilename();
        Descriptors.FileDescriptor fd = null;
        for (Service metadata : this.server.getServices()) {
            if (metadata.descriptor() == null) continue;
            Descriptors.FileDescriptor serviceFile = metadata.descriptor().getFile();
            if (serviceFile.getName().equals(name)) {
                fd = serviceFile;
                break;
            }
            fd = this.findFileDescriptorInDependencies(serviceFile, name);
            if (fd == null) continue;
            break;
        }
        if (fd != null) {
            return this.getServerReflectionResponse(request, fd);
        }
        return this.getErrorResponse(request, GrpcStatus.NOT_FOUND, "File not found (" + name + ")");
    }

    private Descriptors.FileDescriptor findFileDescriptorInDependencies(Descriptors.FileDescriptor fd, String name) {
        if (fd.getName().equals(name)) {
            return fd;
        }
        for (Descriptors.FileDescriptor dep : fd.getDependencies()) {
            Descriptors.FileDescriptor result = this.findFileDescriptorInDependencies(dep, name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private ServerReflectionResponse getFileContainingSymbol(ServerReflectionRequest request) {
        Service metadata;
        String symbol = request.getFileContainingSymbol();
        Descriptors.FileDescriptor fd = null;
        Iterator iterator = this.server.getServices().iterator();
        while (iterator.hasNext() && ((metadata = (Service)iterator.next()).descriptor() == null || (fd = this.findFileDescriptorBySymbol(metadata.descriptor().getFile(), symbol)) == null)) {
        }
        if (fd != null) {
            return this.getServerReflectionResponse(request, fd);
        }
        return this.getErrorResponse(request, GrpcStatus.NOT_FOUND, "Symbol not found (" + symbol + ")");
    }

    private Descriptors.FileDescriptor findFileDescriptorBySymbol(Descriptors.FileDescriptor fd, String symbol) {
        Descriptors.FileDescriptor result;
        for (Descriptors.ServiceDescriptor service : fd.getServices()) {
            if (service.getFullName().equals(symbol)) {
                return fd;
            }
            for (Descriptors.MethodDescriptor method : service.getMethods()) {
                if (!method.getFullName().equals(symbol)) continue;
                return fd;
            }
        }
        for (Descriptors.Descriptor type : fd.getMessageTypes()) {
            result = this.findFileDescriptorByType(type, symbol, fd);
            if (result == null) continue;
            return result;
        }
        for (Descriptors.FileDescriptor dep : fd.getDependencies()) {
            result = this.findFileDescriptorBySymbol(dep, symbol);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private Descriptors.FileDescriptor findFileDescriptorByType(Descriptors.Descriptor type, String symbol, Descriptors.FileDescriptor fd) {
        if (type.getFullName().equals(symbol)) {
            return fd;
        }
        for (Descriptors.Descriptor nestedType : type.getNestedTypes()) {
            Descriptors.FileDescriptor result = this.findFileDescriptorByType(nestedType, symbol, fd);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private ServerReflectionResponse getFileByExtension(ServerReflectionRequest request) {
        Service metadata;
        ExtensionRequest extensionRequest = request.getFileContainingExtension();
        String type = extensionRequest.getContainingType();
        int extension = extensionRequest.getExtensionNumber();
        Descriptors.FileDescriptor fd = null;
        Iterator iterator = this.server.getServices().iterator();
        while (iterator.hasNext() && ((metadata = (Service)iterator.next()).descriptor() == null || (fd = this.findFileDescriptorByExtension(metadata.descriptor().getFile(), type, extension)) == null)) {
        }
        if (fd != null) {
            return this.getServerReflectionResponse(request, fd);
        }
        return this.getErrorResponse(request, GrpcStatus.NOT_FOUND, "Extension not found (" + type + ", " + extension + ")");
    }

    private Descriptors.FileDescriptor findFileDescriptorByExtension(Descriptors.FileDescriptor fd, String type, int number) {
        Descriptors.FileDescriptor result;
        for (Descriptors.FieldDescriptor extension : fd.getExtensions()) {
            if (!extension.getContainingType().getFullName().equals(type) || extension.getNumber() != number) continue;
            return fd;
        }
        for (Descriptors.Descriptor messageType : fd.getMessageTypes()) {
            result = this.findFileDescriptorByExtensionInType(messageType, type, number, fd);
            if (result == null) continue;
            return result;
        }
        for (Descriptors.FileDescriptor dep : fd.getDependencies()) {
            result = this.findFileDescriptorByExtension(dep, type, number);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private Descriptors.FileDescriptor findFileDescriptorByExtensionInType(Descriptors.Descriptor type, String typeName, int number, Descriptors.FileDescriptor fd) {
        for (Descriptors.FieldDescriptor extension : type.getExtensions()) {
            if (!extension.getContainingType().getFullName().equals(typeName) || extension.getNumber() != number) continue;
            return fd;
        }
        for (Descriptors.Descriptor nestedType : type.getNestedTypes()) {
            Descriptors.FileDescriptor result = this.findFileDescriptorByExtensionInType(nestedType, typeName, number, fd);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private ServerReflectionResponse getAllExtensions(ServerReflectionRequest request) {
        String type = request.getAllExtensionNumbersOfType();
        HashSet<Integer> extensions = new HashSet<Integer>();
        for (Service metadata : this.server.getServices()) {
            if (metadata.descriptor() == null) continue;
            this.collectExtensionNumbers(metadata.descriptor().getFile(), type, extensions);
        }
        if (!extensions.isEmpty()) {
            ExtensionNumberResponse.Builder builder = ExtensionNumberResponse.newBuilder().setBaseTypeName(type).addAllExtensionNumber(extensions);
            return ServerReflectionResponse.newBuilder().setValidHost(request.getHost()).setOriginalRequest(request).setAllExtensionNumbersResponse(builder).build();
        }
        return this.getErrorResponse(request, GrpcStatus.NOT_FOUND, "Type not found.");
    }

    private void collectExtensionNumbers(Descriptors.FileDescriptor fd, String type, Set<Integer> extensions) {
        for (Descriptors.FieldDescriptor extension : fd.getExtensions()) {
            if (!extension.getContainingType().getFullName().equals(type)) continue;
            extensions.add(extension.getNumber());
        }
        for (Descriptors.Descriptor messageType : fd.getMessageTypes()) {
            this.collectExtensionNumbersFromType(messageType, type, extensions);
        }
        for (Descriptors.FileDescriptor dep : fd.getDependencies()) {
            this.collectExtensionNumbers(dep, type, extensions);
        }
    }

    private void collectExtensionNumbersFromType(Descriptors.Descriptor type, String typeName, Set<Integer> extensions) {
        for (Descriptors.FieldDescriptor extension : type.getExtensions()) {
            if (!extension.getContainingType().getFullName().equals(typeName)) continue;
            extensions.add(extension.getNumber());
        }
        for (Descriptors.Descriptor nestedType : type.getNestedTypes()) {
            this.collectExtensionNumbersFromType(nestedType, typeName, extensions);
        }
    }

    private ServerReflectionResponse getServerReflectionResponse(ServerReflectionRequest request, Descriptors.FileDescriptor fd) {
        FileDescriptorResponse.Builder fdRBuilder = FileDescriptorResponse.newBuilder();
        HashSet<String> seenFiles = new HashSet<String>();
        ArrayDeque<Descriptors.FileDescriptor> frontier = new ArrayDeque<Descriptors.FileDescriptor>();
        seenFiles.add(fd.getName());
        frontier.add(fd);
        while (!frontier.isEmpty()) {
            Descriptors.FileDescriptor nextFd = (Descriptors.FileDescriptor)frontier.remove();
            fdRBuilder.addFileDescriptorProto(nextFd.toProto().toByteString());
            for (Descriptors.FileDescriptor dependencyFd : nextFd.getDependencies()) {
                if (seenFiles.contains(dependencyFd.getName())) continue;
                seenFiles.add(dependencyFd.getName());
                frontier.add(dependencyFd);
            }
        }
        return ServerReflectionResponse.newBuilder().setValidHost(request.getHost()).setOriginalRequest(request).setFileDescriptorResponse(fdRBuilder).build();
    }

    private ServerReflectionResponse getErrorResponse(ServerReflectionRequest request, GrpcStatus code, String message) {
        return ServerReflectionResponse.newBuilder().setValidHost(request.getHost()).setOriginalRequest(request).setErrorResponse(ErrorResponse.newBuilder().setErrorCode(code.code).setErrorMessage(message)).build();
    }
}

