/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen.processor;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.codegen.processor.CodeGen;
import io.vertx.codegen.processor.GenException;
import io.vertx.codegen.processor.Generator;
import io.vertx.codegen.processor.GeneratorLoader;
import io.vertx.codegen.processor.Model;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.FilerException;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

@SupportedOptions(value={"codegen.generators"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_11)
public class Processor
extends AbstractProcessor {
    private static final String JSON_MAPPERS_PROPERTIES_PATH = "META-INF/vertx/json-mappers.properties";
    private File outputDirectory;
    private List<? extends Generator<?>> codeGenerators;
    private Map<String, GeneratedFile> generatedResources = new HashMap<String, GeneratedFile>();
    private Set<Class<? extends Annotation>> supportedAnnotation = new HashSet<Class<? extends Annotation>>();
    private List<CodeGen.Converter> mappers;

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return this.supportedAnnotation.stream().map(Class::getName).collect(Collectors.toSet());
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.generatedResources.clear();
        this.supportedAnnotation = new HashSet<Class>(Arrays.asList(DataObject.class, VertxGen.class));
        this.getCodeGenerators().stream().flatMap(gen -> gen.annotations().stream()).forEach(this.supportedAnnotation::add);
        if (this.mappers == null) {
            this.mappers = this.loadJsonMappers();
        }
    }

    private Predicate<Generator> filterGenerators() {
        String generatorsOption = this.processingEnv.getOptions().get("codegen.generators");
        if (generatorsOption != null) {
            List wanted = Stream.of(generatorsOption.split(",")).map(String::trim).map(Pattern::compile).collect(Collectors.toList());
            return cg -> wanted.stream().anyMatch(p -> p.matcher(cg.name).matches());
        }
        return null;
    }

    private Collection<? extends Generator<?>> getCodeGenerators() {
        if (this.codeGenerators == null) {
            ServiceLoader<GeneratorLoader> genLoaders = ServiceLoader.load(GeneratorLoader.class, Processor.class.getClassLoader());
            Iterator<GeneratorLoader> it = genLoaders.iterator();
            ArrayList generators = new ArrayList();
            Predicate<Generator> filter = this.filterGenerators();
            while (true) {
                try {
                    while (it.hasNext()) {
                        GeneratorLoader genLoader = it.next();
                        Stream<Generator<?>> generatorStream = genLoader.loadGenerators(this.processingEnv);
                        generatorStream.forEach(generator -> {
                            if (filter != null && !filter.test((Generator)generator)) {
                                return;
                            }
                            generator.load(this.processingEnv);
                            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Loaded " + generator.name + " code generator");
                            generators.add((Generator<?>)generator);
                        });
                    }
                }
                catch (ServiceConfigurationError e) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Could not load code generator: " + e.getMessage());
                    continue;
                }
                break;
            }
            this.codeGenerators = generators;
        }
        return this.codeGenerators;
    }

    private static void loadJsonMappers(List<CodeGen.Converter> list, InputStream is) throws IOException {
        Properties tmp = new Properties();
        tmp.load(is);
        tmp.stringPropertyNames().forEach(name -> {
            int idx = name.lastIndexOf(46);
            if (idx != -1) {
                String type = name.substring(0, idx);
                String value = tmp.getProperty((String)name);
                int idx1 = value.indexOf(35);
                if (idx1 != -1) {
                    String className = value.substring(0, idx1);
                    String rest = value.substring(idx1 + 1);
                    int idx2 = rest.indexOf(46);
                    if (idx2 != -1) {
                        list.add(new CodeGen.Converter(type, className, Arrays.asList(rest.substring(0, idx2), rest.substring(idx2 + 1))));
                    } else {
                        list.add(new CodeGen.Converter(type, className, Collections.singletonList(rest)));
                    }
                }
            }
        });
    }

    private Path determineSourcePathInEclipse() {
        try {
            Filer filer = this.processingEnv.getFiler();
            if (!filer.getClass().getName().startsWith("com.sun.tools.javac")) {
                JavaFileObject generationForPath = filer.createClassFile("PathFor" + this.getClass().getSimpleName(), new Element[0]);
                return new File(generationForPath.toUri()).toPath().getParent();
            }
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Unable to determine source file path!");
        }
        return null;
    }

    private String throwableToMessageString(Throwable e) {
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    private List<CodeGen.Converter> loadJsonMappers() {
        Path source;
        Path path;
        Exception exception = null;
        ArrayList<CodeGen.Converter> merged = new ArrayList<CodeGen.Converter>();
        for (StandardLocation loc : StandardLocation.values()) {
            try {
                FileObject file = this.processingEnv.getFiler().getResource(loc, "", JSON_MAPPERS_PROPERTIES_PATH);
                try (InputStream is = file.openInputStream();){
                    try {
                        Processor.loadJsonMappers(merged, is);
                        exception = null;
                    }
                    catch (IOException e) {
                        exception = e;
                    }
                }
            }
            catch (Exception ignore) {
                exception = ignore;
            }
        }
        if (exception != null) {
            try {
                Enumeration<URL> resources = this.getClass().getClassLoader().getResources(JSON_MAPPERS_PROPERTIES_PATH);
                while (resources.hasMoreElements()) {
                    URL url = resources.nextElement();
                    InputStream is = url.openStream();
                    try {
                        Processor.loadJsonMappers(merged, is);
                        exception = null;
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Loaded json-mappers.properties " + String.valueOf(url));
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
            }
            catch (IOException e) {
                exception = e;
            }
        }
        if (exception != null && (path = this.determineSourcePathInEclipse()) != null && (source = path.getParent().getParent().resolve("src/main/resources").resolve(JSON_MAPPERS_PROPERTIES_PATH)).toFile().exists()) {
            try (InputStream is = source.toUri().toURL().openStream();){
                Processor.loadJsonMappers(merged, is);
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Loaded json-mappers.properties from '" + String.valueOf(source) + "'");
            }
            catch (IOException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, "Could not load json-mappers.properties: " + this.throwableToMessageString(e));
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Unable to open properties file at " + String.valueOf(source));
            }
        }
        if (exception != null) {
            File projectDir;
            Path source2;
            String kaptGeneratedLocation = this.processingEnv.getOptions().get("kapt.kotlin.generated");
            String defaultKaptGeneratedLocation = "/build/generated/source/kaptKotlin/main";
            if (System.getProperty("os.name").toLowerCase(Locale.US).contains("win")) {
                defaultKaptGeneratedLocation = defaultKaptGeneratedLocation.replace('/', File.separatorChar);
            }
            if (kaptGeneratedLocation != null && kaptGeneratedLocation.endsWith(defaultKaptGeneratedLocation) && (source2 = (projectDir = new File(kaptGeneratedLocation.substring(0, kaptGeneratedLocation.length() - defaultKaptGeneratedLocation.length()))).toPath().resolve("src/main/resources").resolve(JSON_MAPPERS_PROPERTIES_PATH)).toFile().exists()) {
                try (InputStream is = source2.toUri().toURL().openStream();){
                    Processor.loadJsonMappers(merged, is);
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Loaded json-mappers.properties from '" + String.valueOf(source2) + "'");
                }
                catch (IOException e) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, "Could not load json-mappers.properties: " + this.throwableToMessageString(e));
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Unable to open properties file at " + String.valueOf(source2));
                }
            }
        }
        return merged;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver()) {
            Collection<? extends Generator<?>> codeGenerators = this.getCodeGenerators();
            if (!roundEnv.errorRaised()) {
                CodeGen codegen = new CodeGen(this.processingEnv);
                this.mappers.forEach(codegen::registerConverter);
                codegen.init(roundEnv, this.getClass().getClassLoader());
                HashMap generatedClasses = new HashMap();
                codegen.getModels().forEach(entry -> {
                    try {
                        Model model = (Model)entry.getValue();
                        for (Generator codeGenerator : codeGenerators) {
                            String relativeName;
                            if (!codeGenerator.kinds.contains(model.getKind()) || (relativeName = codeGenerator.filename(model)) == null) continue;
                            if (!relativeName.startsWith("/") && relativeName.endsWith(".java")) {
                                String fqn = relativeName.substring(0, relativeName.length() - ".java".length());
                                if (this.processingEnv.getElementUtils().getTypeElement(fqn) != null) continue;
                                List processings = generatedClasses.computeIfAbsent(fqn, GeneratedFile::new);
                                processings.add(new ModelProcessing(model, codeGenerator));
                                continue;
                            }
                            List processings = this.generatedResources.computeIfAbsent(relativeName, GeneratedFile::new);
                            processings.add(new ModelProcessing(model, codeGenerator));
                        }
                    }
                    catch (GenException e) {
                        this.reportGenException(e);
                    }
                    catch (Exception e) {
                        this.reportException(e, (Element)entry.getKey());
                    }
                });
                generatedClasses.values().forEach(generated -> {
                    block9: {
                        try {
                            String content = generated.generate();
                            if (content.length() <= 0) break block9;
                            JavaFileObject target = this.processingEnv.getFiler().createSourceFile(generated.uri, new Element[0]);
                            try (Writer writer = target.openWriter();){
                                writer.write(content);
                            }
                            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Generated model " + ((ModelProcessing)generated.get((int)0)).model.getFqn() + ": " + generated.uri);
                        }
                        catch (GenException e) {
                            this.reportGenException(e);
                        }
                        catch (Exception e) {
                            this.reportException(e, ((ModelProcessing)generated.get((int)0)).model.getElement());
                        }
                    }
                });
            }
        } else {
            for (GeneratedFile generated2 : this.generatedResources.values()) {
                try {
                    boolean createSource;
                    String content = generated2.generate();
                    if (generated2.uri.startsWith("/")) {
                        File f = new File(generated2.uri);
                        f.getParentFile().mkdirs();
                        FileOutputStream out = new FileOutputStream(f);
                        try {
                            ((OutputStream)out).write(content.getBytes(StandardCharsets.UTF_8));
                            continue;
                        }
                        finally {
                            ((OutputStream)out).close();
                            continue;
                        }
                    }
                    if (content.isEmpty()) continue;
                    try (Writer w = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", generated2.uri, new Element[0]).openWriter();){
                        w.write(content);
                    }
                    try {
                        this.processingEnv.getFiler().getResource(StandardLocation.SOURCE_OUTPUT, "", generated2.uri);
                        createSource = true;
                    }
                    catch (FilerException e) {
                        createSource = false;
                    }
                    if (createSource) {
                        try (Writer w = this.processingEnv.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, "", generated2.uri, new Element[0]).openWriter();){
                            w.write(content);
                        }
                    }
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Generated model " + ((ModelProcessing)generated2.get((int)0)).model.getFqn() + ": " + generated2.uri);
                }
                catch (GenException e) {
                    this.reportGenException(e);
                }
                catch (Exception e) {
                    this.reportException(e, ((ModelProcessing)generated2.get((int)0)).model.getElement());
                }
            }
        }
        return true;
    }

    private void reportGenException(GenException e) {
        Object name = e.element.toString();
        if (e.element.getKind() == ElementKind.METHOD) {
            name = String.valueOf(e.element.getEnclosingElement()) + "#" + (String)name;
        }
        String msg = "Could not generate model for " + (String)name + ": " + e.msg;
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg + "\nCaused by: " + this.throwableToMessageString(e));
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, e.element);
    }

    private void reportException(Exception e, Element elt) {
        String msg = "Could not generate element for " + String.valueOf(elt) + ": " + e.getMessage();
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg + "\nCaused by: " + this.throwableToMessageString(e));
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, elt);
    }

    private static class GeneratedFile
    extends ArrayList<ModelProcessing> {
        private final String uri;
        private final Map<String, Object> session = new HashMap<String, Object>();

        public GeneratedFile(String uri) {
            this.uri = uri;
        }

        @Override
        public boolean add(ModelProcessing modelProcessing) {
            if (!modelProcessing.generator.incremental) {
                this.clear();
            }
            return super.add(modelProcessing);
        }

        String generate() {
            Collections.sort(this, (o1, o2) -> o1.model.getElement().getSimpleName().toString().compareTo(o2.model.getElement().getSimpleName().toString()));
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < this.size(); ++i) {
                ModelProcessing processing = (ModelProcessing)this.get(i);
                try {
                    String part = processing.generator.render(processing.model, i, this.size(), this.session);
                    if (part == null) continue;
                    buffer.append(part);
                    continue;
                }
                catch (GenException e) {
                    throw e;
                }
                catch (Exception e) {
                    GenException genException = new GenException(processing.model.getElement(), e.getMessage());
                    genException.initCause(e);
                    throw genException;
                }
            }
            return buffer.toString();
        }
    }

    private static class ModelProcessing {
        final Model model;
        final Generator generator;

        public ModelProcessing(Model model, Generator generator) {
            this.model = model;
            this.generator = generator;
        }
    }
}

