/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.plugin;

import com.google.api.AnnotationsProto;
import com.google.api.HttpRule;
import com.google.common.base.Strings;
import com.google.common.html.HtmlEscapers;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.compiler.PluginProtos;
import com.salesforce.jprotoc.Generator;
import com.salesforce.jprotoc.GeneratorException;
import com.salesforce.jprotoc.ProtoTypeMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class VertxGrpcGeneratorImpl
extends Generator {
    private static final int SERVICE_NUMBER_OF_PATHS = 2;
    private static final int METHOD_NUMBER_OF_PATHS = 4;
    private final boolean generateGrpcClient;
    private final boolean generateGrpcService;
    private final boolean generateGrpcIo;
    private static final List<CharSequence> JAVA_KEYWORDS = Arrays.asList("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "true", "false");

    public VertxGrpcGeneratorImpl(boolean generateGrpcClient, boolean generateGrpcService, boolean generateGrpcIo) {
        this.generateGrpcClient = generateGrpcClient;
        this.generateGrpcService = generateGrpcService;
        this.generateGrpcIo = generateGrpcIo;
    }

    private String getServiceJavaDocPrefix() {
        return "    ";
    }

    private String getMethodJavaDocPrefix() {
        return "        ";
    }

    @Override
    protected List<PluginProtos.CodeGeneratorResponse.Feature> supportedFeatures() {
        return Collections.singletonList(PluginProtos.CodeGeneratorResponse.Feature.FEATURE_PROTO3_OPTIONAL);
    }

    @Override
    public List<PluginProtos.CodeGeneratorResponse.File> generateFiles(PluginProtos.CodeGeneratorRequest request) throws GeneratorException {
        ProtoTypeMap typeMap = ProtoTypeMap.of(request.getProtoFileList());
        List<DescriptorProtos.FileDescriptorProto> protosToGenerate = request.getProtoFileList().stream().filter(protoFile -> request.getFileToGenerateList().contains(protoFile.getName())).collect(Collectors.toList());
        List<ServiceContext> services = this.findServices(protosToGenerate, typeMap);
        return this.generateFiles(services);
    }

    private List<ServiceContext> findServices(List<DescriptorProtos.FileDescriptorProto> protos, ProtoTypeMap typeMap) {
        ArrayList<ServiceContext> contexts = new ArrayList<ServiceContext>();
        protos.forEach(fileProto -> {
            for (int serviceNumber = 0; serviceNumber < fileProto.getServiceCount(); ++serviceNumber) {
                ServiceContext serviceContext = this.buildServiceContext(fileProto.getService(serviceNumber), typeMap, fileProto.getSourceCodeInfo().getLocationList(), serviceNumber);
                serviceContext.protoName = fileProto.getName();
                serviceContext.packageName = fileProto.getPackage();
                serviceContext.outerClassName = ProtoTypeMap.getJavaOuterClassname(fileProto);
                serviceContext.javaPackageName = this.extractPackageName((DescriptorProtos.FileDescriptorProto)fileProto);
                contexts.add(serviceContext);
            }
        });
        return contexts;
    }

    private String extractPackageName(DescriptorProtos.FileDescriptorProto proto) {
        String javaPackage;
        DescriptorProtos.FileOptions options = proto.getOptions();
        if (options != null && !Strings.isNullOrEmpty(javaPackage = options.getJavaPackage())) {
            return javaPackage;
        }
        return Strings.nullToEmpty(proto.getPackage());
    }

    private ServiceContext buildServiceContext(DescriptorProtos.ServiceDescriptorProto serviceProto, ProtoTypeMap typeMap, List<DescriptorProtos.SourceCodeInfo.Location> locations, int serviceNumber) {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.serviceName = serviceProto.getName();
        serviceContext.deprecated = serviceProto.getOptions() != null && serviceProto.getOptions().getDeprecated();
        List allLocationsForService = locations.stream().filter(location -> location.getPathCount() >= 2 && location.getPath(0) == 6 && location.getPath(1) == serviceNumber).collect(Collectors.toList());
        DescriptorProtos.SourceCodeInfo.Location serviceLocation = allLocationsForService.stream().filter(location -> location.getPathCount() == 2).findFirst().orElseGet(DescriptorProtos.SourceCodeInfo.Location::getDefaultInstance);
        serviceContext.javaDoc = this.getJavaDoc(this.getComments(serviceLocation), this.getServiceJavaDocPrefix());
        for (int methodNumber = 0; methodNumber < serviceProto.getMethodCount(); ++methodNumber) {
            MethodContext methodContext = this.buildMethodContext(serviceProto.getMethod(methodNumber), typeMap, locations, methodNumber);
            serviceContext.methods.add(methodContext);
        }
        return serviceContext;
    }

    private MethodContext buildMethodContext(DescriptorProtos.MethodDescriptorProto methodProto, ProtoTypeMap typeMap, List<DescriptorProtos.SourceCodeInfo.Location> locations, int methodNumber) {
        MethodContext methodContext = new MethodContext();
        methodContext.methodName = methodProto.getName();
        methodContext.vertxMethodName = VertxGrpcGeneratorImpl.mixedLower(methodProto.getName());
        methodContext.inputType = typeMap.toJavaTypeName(methodProto.getInputType());
        methodContext.outputType = typeMap.toJavaTypeName(methodProto.getOutputType());
        methodContext.deprecated = methodProto.getOptions() != null && methodProto.getOptions().getDeprecated();
        methodContext.isManyInput = methodProto.getClientStreaming();
        methodContext.isManyOutput = methodProto.getServerStreaming();
        methodContext.methodNumber = methodNumber;
        methodContext.transcodingContext = new TranscodingContext();
        DescriptorProtos.SourceCodeInfo.Location methodLocation = locations.stream().filter(location -> location.getPathCount() == 4 && location.getPath(3) == methodNumber).findFirst().orElseGet(DescriptorProtos.SourceCodeInfo.Location::getDefaultInstance);
        methodContext.javaDoc = this.getJavaDoc(this.getComments(methodLocation), this.getMethodJavaDocPrefix());
        if (!methodProto.getClientStreaming() && !methodProto.getServerStreaming()) {
            methodContext.vertxCallsMethodName = "oneToOne";
            methodContext.grpcCallsMethodName = "asyncUnaryCall";
        }
        if (!methodProto.getClientStreaming() && methodProto.getServerStreaming()) {
            methodContext.vertxCallsMethodName = "oneToMany";
            methodContext.grpcCallsMethodName = "asyncServerStreamingCall";
        }
        if (methodProto.getClientStreaming() && !methodProto.getServerStreaming()) {
            methodContext.vertxCallsMethodName = "manyToOne";
            methodContext.grpcCallsMethodName = "asyncClientStreamingCall";
        }
        if (methodProto.getClientStreaming() && methodProto.getServerStreaming()) {
            methodContext.vertxCallsMethodName = "manyToMany";
            methodContext.grpcCallsMethodName = "asyncBidiStreamingCall";
        }
        if (methodProto.getOptions().hasExtension(AnnotationsProto.http)) {
            HttpRule httpRule = methodProto.getOptions().getExtension(AnnotationsProto.http);
            methodContext.transcodingContext = this.buildTranscodingContext(httpRule);
        }
        return methodContext;
    }

    private TranscodingContext buildTranscodingContext(HttpRule rule) {
        TranscodingContext transcodingContext = new TranscodingContext();
        switch (rule.getPatternCase()) {
            case GET: {
                transcodingContext.path = rule.getGet();
                transcodingContext.method = "GET";
                break;
            }
            case POST: {
                transcodingContext.path = rule.getPost();
                transcodingContext.method = "POST";
                break;
            }
            case PUT: {
                transcodingContext.path = rule.getPut();
                transcodingContext.method = "PUT";
                break;
            }
            case DELETE: {
                transcodingContext.path = rule.getDelete();
                transcodingContext.method = "DELETE";
                break;
            }
            case PATCH: {
                transcodingContext.path = rule.getPatch();
                transcodingContext.method = "PATCH";
                break;
            }
            case CUSTOM: {
                transcodingContext.path = rule.getCustom().getPath();
                transcodingContext.method = rule.getCustom().getKind();
            }
        }
        transcodingContext.selector = rule.getSelector();
        transcodingContext.body = rule.getBody();
        transcodingContext.responseBody = rule.getResponseBody();
        transcodingContext.additionalBindings = rule.getAdditionalBindingsList().stream().map(this::buildTranscodingContext).collect(Collectors.toList());
        return transcodingContext;
    }

    private static String mixedLower(String word) {
        StringBuffer w = new StringBuffer();
        w.append(Character.toLowerCase(word.charAt(0)));
        boolean afterUnderscore = false;
        for (int i = 1; i < word.length(); ++i) {
            char c = word.charAt(i);
            if (c == '_') {
                afterUnderscore = true;
                continue;
            }
            if (afterUnderscore) {
                w.append(Character.toUpperCase(c));
            } else {
                w.append(c);
            }
            afterUnderscore = false;
        }
        if (JAVA_KEYWORDS.contains(w)) {
            w.append('_');
        }
        return w.toString();
    }

    private List<PluginProtos.CodeGeneratorResponse.File> generateFiles(List<ServiceContext> services) {
        ArrayList files = new ArrayList();
        return services.stream().map(this::buildFiles).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<PluginProtos.CodeGeneratorResponse.File> buildFiles(ServiceContext context) {
        ArrayList<PluginProtos.CodeGeneratorResponse.File> files = new ArrayList<PluginProtos.CodeGeneratorResponse.File>();
        if (this.generateGrpcClient || this.generateGrpcService) {
            files.add(this.buildBaseFile(context));
        }
        if (this.generateGrpcClient) {
            files.add(this.buildClientFile(context));
            files.add(this.buildGrpcClientFile(context));
        }
        if (this.generateGrpcService) {
            files.add(this.buildServiceFile(context));
            files.add(this.buildGrpcServiceFile(context));
        }
        if (this.generateGrpcIo) {
            files.add(this.buildGrpcIoFile(context));
        }
        return files;
    }

    private PluginProtos.CodeGeneratorResponse.File buildBaseFile(ServiceContext context) {
        context.fileName = context.serviceName + ".java";
        context.className = context.serviceName;
        return this.buildFile(context, this.applyTemplate("base.mustache", context));
    }

    private PluginProtos.CodeGeneratorResponse.File buildClientFile(ServiceContext context) {
        context.fileName = context.serviceName + "Client.java";
        context.className = context.serviceName + "Client";
        return this.buildFile(context, this.applyTemplate("client.mustache", context));
    }

    private PluginProtos.CodeGeneratorResponse.File buildGrpcClientFile(ServiceContext context) {
        context.fileName = context.serviceName + "GrpcClient.java";
        context.className = context.serviceName + "GrpcClient";
        return this.buildFile(context, this.applyTemplate("grpc-client.mustache", context));
    }

    private PluginProtos.CodeGeneratorResponse.File buildServiceFile(ServiceContext context) {
        context.fileName = context.serviceName + "Service.java";
        context.className = context.serviceName + "Service";
        return this.buildFile(context, this.applyTemplate("service.mustache", context));
    }

    private PluginProtos.CodeGeneratorResponse.File buildGrpcServiceFile(ServiceContext context) {
        context.fileName = context.serviceName + "GrpcService.java";
        context.className = context.serviceName + "GrpcService";
        return this.buildFile(context, this.applyTemplate("grpc-service.mustache", context));
    }

    private PluginProtos.CodeGeneratorResponse.File buildGrpcIoFile(ServiceContext context) {
        context.fileName = context.serviceName + "GrpcIo.java";
        context.className = context.serviceName + "GrpcIo";
        return this.buildFile(context, this.applyTemplate("grpc-io.mustache", context));
    }

    private PluginProtos.CodeGeneratorResponse.File buildFile(ServiceContext context, String content) {
        return PluginProtos.CodeGeneratorResponse.File.newBuilder().setName(this.absoluteFileName(context)).setContent(content).build();
    }

    private String absoluteFileName(ServiceContext ctx) {
        String dir = ctx.javaPackageName.replace('.', '/');
        if (Strings.isNullOrEmpty(dir)) {
            return ctx.fileName;
        }
        return dir + "/" + ctx.fileName;
    }

    private String getComments(DescriptorProtos.SourceCodeInfo.Location location) {
        return location.getLeadingComments().isEmpty() ? location.getTrailingComments() : location.getLeadingComments();
    }

    private String getJavaDoc(String comments, String prefix) {
        if (!comments.isEmpty()) {
            StringBuilder builder = new StringBuilder("/**\n").append(prefix).append(" * <pre>\n");
            Arrays.stream(HtmlEscapers.htmlEscaper().escape(comments).split("\n")).map(line -> line.replace("*/", "&#42;&#47;").replace("*", "&#42;")).forEach(line -> builder.append(prefix).append(" * ").append((String)line).append("\n"));
            builder.append(prefix).append(" * </pre>\n").append(prefix).append(" */");
            return builder.toString();
        }
        return null;
    }

    private static class TranscodingContext {
        public String path;
        public String method;
        public String selector;
        public String body;
        public String responseBody;
        public List<TranscodingContext> additionalBindings = new ArrayList<TranscodingContext>();

        private TranscodingContext() {
        }
    }

    private static class MethodContext {
        public String methodName;
        public String vertxMethodName;
        public String inputType;
        public String outputType;
        public boolean deprecated;
        public boolean isManyInput;
        public boolean isManyOutput;
        public String vertxCallsMethodName;
        public String grpcCallsMethodName;
        public int methodNumber;
        public String javaDoc;
        public TranscodingContext transcodingContext;

        private MethodContext() {
        }

        public String methodNameUpperUnderscore() {
            StringBuilder s2 = new StringBuilder();
            for (int i = 0; i < this.methodName.length(); ++i) {
                char c = this.methodName.charAt(i);
                s2.append(Character.toUpperCase(c));
                if (i >= this.methodName.length() - 1 || !Character.isLowerCase(c) || !Character.isUpperCase(this.methodName.charAt(i + 1))) continue;
                s2.append('_');
            }
            return s2.toString();
        }

        public String methodNameGetter() {
            return VertxGrpcGeneratorImpl.mixedLower("get_" + this.methodName + "_method");
        }

        public String methodHeader() {
            Object mh = "";
            if (!Strings.isNullOrEmpty(this.javaDoc)) {
                mh = this.javaDoc;
            }
            if (this.deprecated) {
                mh = (String)mh + "\n        @Deprecated";
            }
            return mh;
        }
    }

    private static class ServiceContext {
        public String fileName;
        public String protoName;
        public String packageName;
        public String javaPackageName;
        public String className;
        public String serviceName;
        public String outerClassName;
        public boolean deprecated;
        public String javaDoc;
        public final List<MethodContext> methods = new ArrayList<MethodContext>();

        private ServiceContext() {
        }

        public List<MethodContext> allMethods() {
            return this.methods;
        }

        public List<MethodContext> streamMethods() {
            return this.methods.stream().filter(m3 -> m3.isManyInput || m3.isManyOutput).collect(Collectors.toList());
        }

        public List<MethodContext> unaryUnaryMethods() {
            return this.methods.stream().filter(m3 -> !m3.isManyInput && !m3.isManyOutput).collect(Collectors.toList());
        }

        public List<MethodContext> unaryManyMethods() {
            return this.methods.stream().filter(m3 -> !m3.isManyInput && m3.isManyOutput).collect(Collectors.toList());
        }

        public List<MethodContext> manyUnaryMethods() {
            return this.methods.stream().filter(m3 -> m3.isManyInput && !m3.isManyOutput).collect(Collectors.toList());
        }

        public List<MethodContext> manyManyMethods() {
            return this.methods.stream().filter(m3 -> m3.isManyInput && m3.isManyOutput).collect(Collectors.toList());
        }

        public List<MethodContext> transcodingMethods() {
            return this.methods.stream().filter(t -> t.transcodingContext != null && t.transcodingContext.path != null).collect(Collectors.toList());
        }
    }
}

