/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.common;

import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.grpc.common.GrpcMessageDecoder;
import io.vertx.grpc.common.GrpcMessageEncoder;
import io.vertx.grpc.common.ServiceName;

@GenIgnore(value={"permitted-type"})
public interface ServiceMethod<I, O> {
    public static <Req, Resp> ServiceMethod<Resp, Req> client(final ServiceName serviceName, final String methodName, final GrpcMessageEncoder<Req> encoder, final GrpcMessageDecoder<Resp> decoder) {
        return new ServiceMethod<Resp, Req>(){

            @Override
            public ServiceName serviceName() {
                return serviceName;
            }

            @Override
            public String methodName() {
                return methodName;
            }

            @Override
            public GrpcMessageDecoder<Resp> decoder() {
                return decoder;
            }

            @Override
            public GrpcMessageEncoder<Req> encoder() {
                return encoder;
            }
        };
    }

    public static <Req, Resp> ServiceMethod<Req, Resp> server(final ServiceName serviceName, final String methodName, final GrpcMessageEncoder<Resp> encoder, final GrpcMessageDecoder<Req> decoder) {
        return new ServiceMethod<Req, Resp>(){

            @Override
            public ServiceName serviceName() {
                return serviceName;
            }

            @Override
            public String methodName() {
                return methodName;
            }

            @Override
            public GrpcMessageDecoder<Req> decoder() {
                return decoder;
            }

            @Override
            public GrpcMessageEncoder<Resp> encoder() {
                return encoder;
            }
        };
    }

    public ServiceName serviceName();

    public String methodName();

    default public String fullMethodName() {
        return this.serviceName().fullyQualifiedName() + "/" + this.methodName();
    }

    public GrpcMessageDecoder<I> decoder();

    public GrpcMessageEncoder<O> encoder();
}

