/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.common;

import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.spi.context.storage.ContextLocal;
import io.vertx.grpc.common.impl.GrpcRequestLocalRegistration;
import java.time.Instant;

public class GrpcLocal {
    public static final ContextLocal<GrpcLocal> CONTEXT_LOCAL_KEY = GrpcRequestLocalRegistration.CONTEXT_LOCAL;
    private final long deadlineMillis;
    private Instant deadline;

    public GrpcLocal(long deadlineMillis) {
        this.deadlineMillis = deadlineMillis;
    }

    public static GrpcLocal of(Context context) {
        return (GrpcLocal)((ContextInternal)context).getLocal(CONTEXT_LOCAL_KEY);
    }

    public static GrpcLocal current() {
        Context ctx = Vertx.currentContext();
        return ctx != null ? GrpcLocal.of(ctx) : null;
    }

    public Instant deadline() {
        if (this.deadline == null) {
            this.deadline = Instant.ofEpochMilli(this.deadlineMillis);
        }
        return this.deadline;
    }
}

