/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.common.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.compression.GzipOptions;
import io.netty.handler.codec.compression.StandardCompressionOptions;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.compression.ZlibEncoder;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.internal.buffer.BufferInternal;
import io.vertx.grpc.common.CodecException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Queue;
import java.util.function.Function;

public class Utils {
    public static final Function<Buffer, Buffer> GZIP_DECODER = data -> {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{ZlibCodecFactory.newZlibDecoder((ZlibWrapper)ZlibWrapper.GZIP)});
        channel.config().setAllocator(BufferInternal.buffer().getByteBuf().alloc());
        try {
            ChannelFuture fut = channel.writeOneInbound((Object)((BufferInternal)data).getByteBuf());
            if (fut.isSuccess()) {
                ByteBuf buf;
                BufferInternal decoded = null;
                while ((buf = (ByteBuf)channel.readInbound()) != null) {
                    if (decoded == null) {
                        decoded = BufferInternal.buffer((ByteBuf)buf);
                        continue;
                    }
                    decoded.appendBuffer((Buffer)BufferInternal.buffer((ByteBuf)buf));
                }
                if (decoded == null) {
                    throw new CodecException("Invalid GZIP input");
                }
                BufferInternal bufferInternal = decoded;
                return bufferInternal;
            }
            throw new CodecException(fut.cause());
        }
        finally {
            channel.close();
        }
    };
    public static final Function<Buffer, Buffer> GZIP_ENCODER = data -> {
        ByteBuf a;
        CompositeByteBuf composite = Unpooled.compositeBuffer();
        GzipOptions options = StandardCompressionOptions.gzip();
        ZlibEncoder encoder = ZlibCodecFactory.newZlibEncoder((ZlibWrapper)ZlibWrapper.GZIP, (int)options.compressionLevel(), (int)options.windowBits(), (int)options.memLevel());
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{encoder});
        channel.config().setAllocator(BufferInternal.buffer().getByteBuf().alloc());
        channel.writeOutbound(new Object[]{((BufferInternal)data).getByteBuf()});
        channel.finish();
        Queue messages = channel.outboundMessages();
        while ((a = (ByteBuf)messages.poll()) != null) {
            composite.addComponent(true, a);
        }
        channel.close();
        return BufferInternal.buffer((ByteBuf)composite);
    };

    public static String utf8PercentEncode(String s) {
        try {
            return URLEncoder.encode(s, StandardCharsets.UTF_8.name()).replace("+", "%20").replace("*", "%2A").replace("~", "%7E");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

