/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.common.impl;

import io.vertx.core.Handler;
import io.vertx.grpc.common.GrpcMessage;
import io.vertx.grpc.common.GrpcReadStream;
import io.vertx.grpc.common.impl.BridgeMessageDecoder;
import java.util.LinkedList;

public class ReadStreamAdapter<T> {
    private static final int MAX_INFLIGHT_MESSAGES = 16;
    private final LinkedList<T> queue = new LinkedList();
    private int requests = 0;
    private boolean ended;
    private boolean closed;
    private GrpcReadStream<T> stream;

    public final void init(GrpcReadStream<T> stream, BridgeMessageDecoder<T> decoder) {
        stream.messageHandler((Handler<GrpcMessage>)((Handler)msg -> {
            LinkedList<T> linkedList = this.queue;
            synchronized (linkedList) {
                this.queue.add(decoder.decode((GrpcMessage)msg));
                if (this.queue.size() > 16) {
                    stream.pause();
                }
            }
            this.checkPending();
        }));
        stream.endHandler(v -> {
            LinkedList<T> linkedList = this.queue;
            synchronized (linkedList) {
                this.ended = true;
            }
            this.checkPending();
        });
        this.stream = stream;
    }

    protected void handleClose() {
    }

    protected void handleMessage(T msg) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void request(int num) {
        LinkedList<T> linkedList = this.queue;
        synchronized (linkedList) {
            this.requests += num;
        }
        this.checkPending();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPending() {
        boolean doResume = false;
        while (true) {
            T msg;
            LinkedList<T> linkedList = this.queue;
            synchronized (linkedList) {
                if (this.queue.isEmpty()) {
                    if (!this.ended || this.closed) {
                        break;
                    }
                    this.closed = true;
                    msg = null;
                } else {
                    if (this.requests == 0) {
                        break;
                    }
                    if (this.queue.size() == 16) {
                        doResume = true;
                    }
                    --this.requests;
                    msg = this.queue.poll();
                }
            }
            if (msg == null) {
                this.handleClose();
                continue;
            }
            this.handleMessage(msg);
        }
        if (doResume) {
            this.stream.resume();
        }
    }
}

