/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.client.impl;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.net.Address;
import io.vertx.grpc.client.GrpcClient;
import io.vertx.grpc.client.GrpcClientOptions;
import io.vertx.grpc.client.GrpcClientRequest;
import io.vertx.grpc.client.impl.GrpcClientRequestImpl;
import io.vertx.grpc.common.GrpcLocal;
import io.vertx.grpc.common.GrpcMessageDecoder;
import io.vertx.grpc.common.GrpcMessageEncoder;
import io.vertx.grpc.common.ServiceMethod;
import java.util.concurrent.TimeUnit;

public class GrpcClientImpl
implements GrpcClient {
    private final Vertx vertx;
    private HttpClient client;
    private boolean closeClient;
    private final boolean scheduleDeadlineAutomatically;
    private final long maxMessageSize;
    private final int timeout;
    private final TimeUnit timeoutUnit;

    public GrpcClientImpl(Vertx vertx, HttpClient client) {
        this(vertx, new GrpcClientOptions(), client, false);
    }

    protected GrpcClientImpl(Vertx vertx, GrpcClientOptions grpcOptions, HttpClient client, boolean close) {
        this.vertx = vertx;
        this.client = client;
        this.scheduleDeadlineAutomatically = grpcOptions.getScheduleDeadlineAutomatically();
        this.maxMessageSize = grpcOptions.getMaxMessageSize();
        this.timeout = grpcOptions.getTimeout();
        this.timeoutUnit = grpcOptions.getTimeoutUnit();
        this.closeClient = close;
    }

    public Future<GrpcClientRequest<Buffer, Buffer>> request(RequestOptions options) {
        return this.client.request(options).map(httpRequest -> {
            GrpcClientRequestImpl grpcRequest = new GrpcClientRequestImpl((HttpClientRequest)httpRequest, this.maxMessageSize, this.scheduleDeadlineAutomatically, GrpcMessageEncoder.IDENTITY, GrpcMessageDecoder.IDENTITY);
            grpcRequest.init();
            this.configureTimeout(grpcRequest);
            return grpcRequest;
        });
    }

    @Override
    public Future<GrpcClientRequest<Buffer, Buffer>> request() {
        return this.request(new RequestOptions().setMethod(HttpMethod.POST));
    }

    @Override
    public Future<GrpcClientRequest<Buffer, Buffer>> request(Address server) {
        return this.request(new RequestOptions().setMethod(HttpMethod.POST).setServer(server));
    }

    private void configureTimeout(GrpcClientRequest<?, ?> request) {
        ContextInternal current = (ContextInternal)this.vertx.getOrCreateContext();
        GrpcLocal local = (GrpcLocal)current.getLocal(GrpcLocal.CONTEXT_LOCAL_KEY);
        long timeout = this.timeout;
        TimeUnit timeoutUnit = this.timeoutUnit;
        if (local != null) {
            timeout = local.deadline().toEpochMilli() - System.currentTimeMillis();
            timeoutUnit = TimeUnit.MILLISECONDS;
            if (timeout < 0L) {
                throw new UnsupportedOperationException("Handle this case");
            }
        }
        request.timeout(timeout, timeoutUnit);
    }

    @Override
    public <Req, Resp> Future<GrpcClientRequest<Req, Resp>> request(ServiceMethod<Resp, Req> method) {
        return this.request(new RequestOptions().setMethod(HttpMethod.POST), method);
    }

    @Override
    public <Req, Resp> Future<GrpcClientRequest<Req, Resp>> request(Address server, ServiceMethod<Resp, Req> method) {
        return this.request(new RequestOptions().setMethod(HttpMethod.POST).setServer(server), method);
    }

    private <Req, Resp> Future<GrpcClientRequest<Req, Resp>> request(RequestOptions options, ServiceMethod<Resp, Req> method) {
        return this.client.request(options).map(request -> {
            GrpcClientRequestImpl call = new GrpcClientRequestImpl((HttpClientRequest)request, this.maxMessageSize, this.scheduleDeadlineAutomatically, method.encoder(), method.decoder());
            call.init();
            call.serviceName(method.serviceName());
            call.methodName(method.methodName());
            this.configureTimeout(call);
            return call;
        });
    }

    @Override
    public Future<Void> close() {
        if (this.closeClient) {
            return this.client.close();
        }
        return ((VertxInternal)this.vertx).getOrCreateContext().succeededFuture();
    }
}

