/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.streams.impl;

import io.netty.util.internal.PlatformDependent;
import io.vertx.core.impl.Arguments;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.Predicate;

public abstract class MessagePassingQueue<E> {
    public static final int UNWRITABLE_MASK = 1;
    public static final int WRITABLE_MASK = 2;
    public static final int DRAIN_REQUIRED_MASK = 4;
    public static final int DEFAULT_HIGH_WATER_MARK = 16;
    public static final int DEFAULT_LOW_WATER_MARK = 8;
    private final Predicate<E> consumer;
    protected final long highWaterMark;
    protected final long lowWaterMark;
    final Queue<E> queue;
    private E overflow;
    private int numberOfUnwritableTimes;
    public static final Factory MPSC = new Factory(){

        public <T> MessagePassingQueue<T> create(Predicate<T> consumer, int lowWaterMark, int highWaterMark) {
            return new MpSc<T>(consumer, lowWaterMark, highWaterMark);
        }

        public <T> MessagePassingQueue<T> create(Predicate<T> consumer) {
            return new MpSc<T>(consumer);
        }
    };
    public static final Factory SPSC = new Factory(){

        public <T> MessagePassingQueue<T> create(Predicate<T> consumer, int lowWaterMark, int highWaterMark) {
            return new SpSc<T>(consumer, lowWaterMark, highWaterMark);
        }

        public <T> MessagePassingQueue<T> create(Predicate<T> consumer) {
            return new SpSc<T>(consumer);
        }
    };
    public static final Factory SINGLE_THREAD = new Factory(){

        public <T> MessagePassingQueue<T> create(Predicate<T> consumer, int lowWaterMark, int highWaterMark) {
            return new SingleThread<T>(consumer, lowWaterMark, highWaterMark);
        }

        public <T> MessagePassingQueue<T> create(Predicate<T> consumer) {
            return new SingleThread<T>(consumer);
        }
    };

    public MessagePassingQueue(Queue<E> queue, Predicate<E> consumer, long lowWaterMark, long highWaterMark) {
        Arguments.require(lowWaterMark > 0L, "The low-water mark must be > 0");
        Arguments.require(lowWaterMark <= highWaterMark, "The high-water mark must greater or equals to the low-water mark");
        this.queue = queue;
        this.consumer = Objects.requireNonNull(consumer, "Consumer must be not null");
        this.lowWaterMark = lowWaterMark;
        this.highWaterMark = highWaterMark;
    }

    public long highWaterMark() {
        return this.highWaterMark;
    }

    public long lowWaterMark() {
        return this.lowWaterMark;
    }

    public int add(E element) {
        long val;
        if (element == null) {
            throw new NullPointerException();
        }
        if (this.wipCompareAndSet(0L, 1L)) {
            this.overflow = element;
            val = 1L;
        } else {
            this.queue.add(element);
            val = this.wipIncrementAndGet();
        }
        if (val != 1L) {
            return val == this.highWaterMark ? 1 : 0;
        }
        return 4 | (1L == this.highWaterMark ? 1 : 0);
    }

    public int drain() {
        return this.drain(Long.MAX_VALUE);
    }

    public int drain(long maxIter) {
        if (maxIter < 0L) {
            throw new IllegalArgumentException();
        }
        if (maxIter == 0L) {
            return 0;
        }
        E elt = this.overflow;
        if (elt != null) {
            if (!this.consumer.test(elt)) {
                return this.drainResult((int)this.wipGet());
            }
            this.overflow = null;
            if (this.consume(1) == 0L) {
                return this.drainResult(0);
            }
            if (maxIter != Long.MAX_VALUE) {
                --maxIter;
            }
        }
        this.hook();
        return this.drainLoop(maxIter);
    }

    private int drainLoop(long maxIter) {
        int consumed;
        long pending = this.wipGet();
        block0: do {
            consumed = 0;
            while ((long)consumed < pending && maxIter > 0L) {
                E elt = this.queue.poll();
                if (maxIter != Long.MAX_VALUE) {
                    --maxIter;
                }
                if (!this.consumer.test(elt)) {
                    this.overflow = elt;
                    continue block0;
                }
                ++consumed;
            }
        } while ((pending = this.consume(consumed)) != 0L && this.overflow == null && maxIter > 0L);
        return this.drainResult((int)pending);
    }

    private int drainResult(int pending) {
        boolean writabilityChanged = (long)pending < this.lowWaterMark && this.numberOfUnwritableTimes > 0;
        int val = this.numberOfUnwritableTimes;
        if (writabilityChanged) {
            this.numberOfUnwritableTimes = 0;
        }
        return MessagePassingQueue.drainResult(val, pending, writabilityChanged);
    }

    private long consume(int amount) {
        long pending = this.wipAddAndGet(-amount);
        long size = pending + (long)amount;
        if (size >= this.highWaterMark && size - (long)amount < this.highWaterMark) {
            ++this.numberOfUnwritableTimes;
        }
        return pending;
    }

    protected void hook() {
    }

    public final List<E> clear() {
        this.numberOfUnwritableTimes = 0;
        ArrayList<E> elts = new ArrayList<E>();
        if (this.overflow != null) {
            elts.add(this.overflow);
            this.overflow = null;
            if (this.wipDecrementAndGet() == 0L) {
                return elts;
            }
        }
        long pending = this.wipGet();
        while (pending != 0L) {
            int i = 0;
            while ((long)i < pending) {
                elts.add(this.queue.poll());
                ++i;
            }
            pending = this.wipAddAndGet(-pending);
        }
        return elts;
    }

    public static int drainResult(int numberOfUnwritableSignals, int numberOfPendingElements, boolean writable) {
        return (writable ? 2 : 0) | (numberOfPendingElements > 0 ? 4 : 0) | numberOfPendingElements << 3 | numberOfUnwritableSignals << 16;
    }

    public static int numberOfPendingElements(int value) {
        return (value & 0xFFF8) >> 3;
    }

    public static int numberOfUnwritableSignals(int value) {
        return (value & 0xFFFF0000) >> 16;
    }

    protected abstract boolean wipCompareAndSet(long var1, long var3);

    protected abstract long wipIncrementAndGet();

    protected abstract long wipDecrementAndGet();

    protected abstract long wipGet();

    protected abstract long wipAddAndGet(long var1);

    public static class SpSc<E>
    extends MessagePassingQueue<E> {
        private static final AtomicLongFieldUpdater<SpSc<?>> WIP_UPDATER = AtomicLongFieldUpdater.newUpdater(SpSc.class, "wip");
        private volatile long wip;

        public SpSc(Predicate<E> consumer) {
            this(consumer, 8, 16);
        }

        public SpSc(Predicate<E> consumer, int lowWaterMark, int highWaterMark) {
            super(PlatformDependent.newSpscQueue(), consumer, lowWaterMark, highWaterMark);
        }

        @Override
        protected boolean wipCompareAndSet(long expect, long update) {
            return WIP_UPDATER.compareAndSet(this, expect, update);
        }

        @Override
        protected long wipIncrementAndGet() {
            return WIP_UPDATER.incrementAndGet(this);
        }

        @Override
        protected long wipDecrementAndGet() {
            return WIP_UPDATER.decrementAndGet(this);
        }

        @Override
        protected long wipGet() {
            return WIP_UPDATER.get(this);
        }

        @Override
        protected long wipAddAndGet(long delta) {
            return WIP_UPDATER.addAndGet(this, delta);
        }
    }

    public static class MpSc<E>
    extends MessagePassingQueue<E> {
        private static final AtomicLongFieldUpdater<MpSc<?>> WIP_UPDATER = AtomicLongFieldUpdater.newUpdater(MpSc.class, "wip");
        private volatile long wip;

        public MpSc(Predicate<E> consumer) {
            this(consumer, 8, 16);
        }

        public MpSc(Predicate<E> consumer, int lowWaterMark, int highWaterMark) {
            super(PlatformDependent.newMpscQueue(), consumer, lowWaterMark, highWaterMark);
        }

        public int write(E element) {
            int res = this.add(element);
            if ((res & 4) != 0) {
                return this.drain();
            }
            return res;
        }

        @Override
        protected boolean wipCompareAndSet(long expect, long update) {
            return WIP_UPDATER.compareAndSet(this, expect, update);
        }

        @Override
        protected long wipIncrementAndGet() {
            return WIP_UPDATER.incrementAndGet(this);
        }

        @Override
        protected long wipDecrementAndGet() {
            return WIP_UPDATER.decrementAndGet(this);
        }

        @Override
        protected long wipGet() {
            return WIP_UPDATER.get(this);
        }

        @Override
        protected long wipAddAndGet(long delta) {
            return WIP_UPDATER.addAndGet(this, delta);
        }
    }

    public static class SingleThread<E>
    extends MessagePassingQueue<E> {
        private long wip;

        public SingleThread(Predicate<E> consumer) {
            this(consumer, 8, 16);
        }

        public SingleThread(Predicate<E> consumer, int lowWaterMark, int highWaterMark) {
            super(new ArrayDeque(1), consumer, lowWaterMark, highWaterMark);
        }

        @Override
        protected boolean wipCompareAndSet(long expect, long update) {
            if (this.wip == expect) {
                this.wip = update;
                return true;
            }
            return false;
        }

        @Override
        protected long wipIncrementAndGet() {
            return ++this.wip;
        }

        @Override
        protected long wipDecrementAndGet() {
            return --this.wip;
        }

        @Override
        protected long wipGet() {
            return this.wip;
        }

        @Override
        protected long wipAddAndGet(long delta) {
            return this.wip += delta;
        }
    }

    public static interface Factory {
        public <E> MessagePassingQueue<E> create(Predicate<E> var1, int var2, int var3);

        public <E> MessagePassingQueue<E> create(Predicate<E> var1);
    }
}

