/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.core.Vertx;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.KeyManagerFactoryWrapper;
import java.util.Objects;
import java.util.function.Function;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509KeyManager;

class KeyManagerFactoryOptions
implements KeyCertOptions {
    private final KeyManagerFactory keyManagerFactory;

    KeyManagerFactoryOptions(KeyManagerFactory keyManagerFactory) {
        if (keyManagerFactory == null || keyManagerFactory.getKeyManagers() == null || keyManagerFactory.getKeyManagers().length == 0) {
            throw new IllegalArgumentException("KeyManagerFactory is not present or is not initialized yet");
        }
        this.keyManagerFactory = keyManagerFactory;
    }

    KeyManagerFactoryOptions(X509KeyManager keyManager) {
        this(new KeyManagerFactoryWrapper(keyManager));
    }

    private KeyManagerFactoryOptions(KeyManagerFactoryOptions other) {
        this.keyManagerFactory = other.keyManagerFactory;
    }

    @Override
    public KeyCertOptions copy() {
        return new KeyManagerFactoryOptions(this);
    }

    @Override
    public KeyManagerFactory getKeyManagerFactory(Vertx vertx) {
        return this.keyManagerFactory;
    }

    @Override
    public Function<String, KeyManagerFactory> keyManagerFactoryMapper(Vertx vertx) throws Exception {
        return name -> null;
    }

    public int hashCode() {
        return this.keyManagerFactory.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof KeyManagerFactoryOptions) {
            KeyManagerFactoryOptions that = (KeyManagerFactoryOptions)obj;
            return Objects.equals(this.keyManagerFactory, that.keyManagerFactory);
        }
        return false;
    }
}

