/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.netty.channel.EventLoop;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.ThreadingModel;
import io.vertx.core.impl.ContextBase;
import io.vertx.core.impl.EventLoopExecutor;
import io.vertx.core.impl.ExecuteBlocking;
import io.vertx.core.impl.TaskQueue;
import io.vertx.core.impl.VertxImpl;
import io.vertx.core.internal.CloseFuture;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.EventExecutor;
import io.vertx.core.internal.WorkerPool;
import io.vertx.core.internal.deployment.DeploymentContext;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.tracing.VertxTracer;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;

public final class ShadowContext
extends ContextBase {
    final VertxImpl owner;
    final ContextBase delegate;
    private final EventLoopExecutor eventLoop;
    final TaskQueue orderedTasks;

    ShadowContext(VertxImpl owner, EventLoopExecutor eventLoop, ContextInternal delegate) {
        super(((ContextBase)delegate).locals);
        this.owner = owner;
        this.eventLoop = eventLoop;
        this.delegate = (ContextBase)delegate;
        this.orderedTasks = new TaskQueue();
    }

    public ContextInternal delegate() {
        return this.delegate;
    }

    @Override
    public EventExecutor eventLoop() {
        return this.eventLoop;
    }

    @Override
    public EventExecutor executor() {
        return this.delegate.executor();
    }

    @Override
    public EventLoop nettyEventLoop() {
        return this.eventLoop.eventLoop;
    }

    @Override
    public DeploymentContext deployment() {
        return null;
    }

    @Override
    public VertxImpl owner() {
        return this.owner;
    }

    @Override
    public void reportException(Throwable t) {
        this.delegate.reportException(t);
    }

    @Override
    public ConcurrentMap<Object, Object> contextData() {
        return this.delegate.contextData();
    }

    @Override
    public ClassLoader classLoader() {
        return this.delegate.classLoader();
    }

    @Override
    public WorkerPool workerPool() {
        return this.owner.workerPool();
    }

    @Override
    public VertxTracer tracer() {
        return this.delegate.tracer();
    }

    @Override
    public ContextInternal duplicate(boolean copy) {
        return new ShadowContext(this.owner, this.eventLoop, this.delegate.duplicate(copy));
    }

    @Override
    public ContextInternal unwrap() {
        if (this.isDuplicate()) {
            return new ShadowContext(this.owner, this.eventLoop, this.delegate.unwrap());
        }
        return this;
    }

    @Override
    public boolean isDuplicate() {
        return this.delegate.isDuplicate();
    }

    @Override
    public CloseFuture closeFuture() {
        return this.owner.closeFuture();
    }

    @Override
    public Future<Void> close() {
        return Future.succeededFuture();
    }

    @Override
    public <T> Future<@Nullable T> executeBlocking(Callable<T> blockingCodeHandler, boolean ordered) {
        return ExecuteBlocking.executeBlocking(this.owner.workerPool(), this, blockingCodeHandler, ordered ? this.orderedTasks : null);
    }

    @Override
    public @Nullable JsonObject config() {
        return null;
    }

    @Override
    public boolean isEventLoopContext() {
        return false;
    }

    @Override
    public boolean isWorkerContext() {
        return false;
    }

    @Override
    public ThreadingModel threadingModel() {
        return ThreadingModel.EXTERNAL;
    }

    @Override
    public Context exceptionHandler(@Nullable Handler<Throwable> handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public @Nullable Handler<Throwable> exceptionHandler() {
        throw new UnsupportedOperationException();
    }
}

