/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.dns;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.dns.AddressResolverOptions;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.Map;

public class AddressResolverOptionsConverter {
    static void fromJson(Iterable<Map.Entry<String, Object>> json, AddressResolverOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "hostsPath": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setHostsPath((String)member.getValue());
                    break;
                }
                case "hostsValue": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setHostsValue(Buffer.fromJson((String)member.getValue()));
                    break;
                }
                case "hostsRefreshPeriod": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setHostsRefreshPeriod(((Number)member.getValue()).intValue());
                    break;
                }
                case "servers": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list = new ArrayList<String>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj.setServers(list);
                    break;
                }
                case "optResourceEnabled": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setOptResourceEnabled((Boolean)member.getValue());
                    break;
                }
                case "cacheMinTimeToLive": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setCacheMinTimeToLive(((Number)member.getValue()).intValue());
                    break;
                }
                case "cacheMaxTimeToLive": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setCacheMaxTimeToLive(((Number)member.getValue()).intValue());
                    break;
                }
                case "cacheNegativeTimeToLive": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setCacheNegativeTimeToLive(((Number)member.getValue()).intValue());
                    break;
                }
                case "queryTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setQueryTimeout(((Number)member.getValue()).longValue());
                    break;
                }
                case "maxQueries": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxQueries(((Number)member.getValue()).intValue());
                    break;
                }
                case "rdFlag": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setRdFlag((Boolean)member.getValue());
                    break;
                }
                case "searchDomains": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj.setSearchDomains(list);
                    break;
                }
                case "ndots": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setNdots(((Number)member.getValue()).intValue());
                    break;
                }
                case "rotateServers": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setRotateServers((Boolean)member.getValue());
                    break;
                }
                case "roundRobinInetAddress": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setRoundRobinInetAddress((Boolean)member.getValue());
                }
            }
        }
    }

    static void toJson(AddressResolverOptions obj, JsonObject json) {
        AddressResolverOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(AddressResolverOptions obj, Map<String, Object> json) {
        JsonArray array;
        if (obj.getHostsPath() != null) {
            json.put("hostsPath", obj.getHostsPath());
        }
        if (obj.getHostsValue() != null) {
            json.put("hostsValue", obj.getHostsValue().toJson());
        }
        json.put("hostsRefreshPeriod", obj.getHostsRefreshPeriod());
        if (obj.getServers() != null) {
            array = new JsonArray();
            obj.getServers().forEach(item -> array.add(item));
            json.put("servers", array);
        }
        json.put("optResourceEnabled", obj.isOptResourceEnabled());
        json.put("cacheMinTimeToLive", obj.getCacheMinTimeToLive());
        json.put("cacheMaxTimeToLive", obj.getCacheMaxTimeToLive());
        json.put("cacheNegativeTimeToLive", obj.getCacheNegativeTimeToLive());
        json.put("queryTimeout", obj.getQueryTimeout());
        json.put("maxQueries", obj.getMaxQueries());
        json.put("rdFlag", obj.getRdFlag());
        if (obj.getSearchDomains() != null) {
            array = new JsonArray();
            obj.getSearchDomains().forEach(item -> array.add(item));
            json.put("searchDomains", array);
        }
        json.put("ndots", obj.getNdots());
        json.put("rotateServers", obj.isRotateServers());
        json.put("roundRobinInetAddress", obj.isRoundRobinInetAddress());
    }
}

