/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.verticle;

import io.vertx.core.impl.verticle.JavaSourceContext;
import io.vertx.core.impl.verticle.MemoryFileManager;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.internal.net.RFC3986;
import java.io.File;
import java.net.URL;
import java.util.Collections;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;

public class CompilingClassLoader
extends ClassLoader {
    private static final Logger log = LoggerFactory.getLogger(CompilingClassLoader.class);
    private final JavaSourceContext javaSourceContext;
    private final MemoryFileManager fileManager;

    public CompilingClassLoader(ClassLoader loader, String sourceName) {
        block8: {
            super(loader);
            URL resource = this.getResource(sourceName);
            if (resource == null) {
                throw new RuntimeException("Resource not found: " + sourceName);
            }
            File sourceFile = new File(RFC3986.decodeURIComponent(resource.getFile(), false));
            if (!sourceFile.canRead()) {
                throw new RuntimeException("File not found: " + sourceFile.getAbsolutePath() + " current dir is: " + new File(".").getAbsolutePath());
            }
            this.javaSourceContext = new JavaSourceContext(sourceFile);
            try {
                DiagnosticCollector diagnostics = new DiagnosticCollector();
                JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
                if (javaCompiler == null) {
                    throw new RuntimeException("Unable to detect java compiler, make sure you're using a JDK not a JRE!");
                }
                StandardJavaFileManager standardFileManager = javaCompiler.getStandardFileManager(null, null, null);
                standardFileManager.setLocation(StandardLocation.SOURCE_PATH, Collections.singleton(this.javaSourceContext.getSourceRoot()));
                this.fileManager = new MemoryFileManager(loader, standardFileManager);
                JavaFileObject javaFile = standardFileManager.getJavaFileForInput(StandardLocation.SOURCE_PATH, this.resolveMainClassName(), JavaFileObject.Kind.SOURCE);
                JavaCompiler.CompilationTask task = javaCompiler.getTask(null, this.fileManager, diagnostics, null, null, Collections.singleton(javaFile));
                boolean valid = task.call();
                if (valid) {
                    for (Diagnostic d : diagnostics.getDiagnostics()) {
                        String code = d.getCode();
                        if (code != null && (code.startsWith("compiler.warn.annotation.method.not.found") || "compiler.warn.proc.processor.incompatible.source.version".equals(code))) continue;
                        log.info(d);
                    }
                    break block8;
                }
                for (Diagnostic d : diagnostics.getDiagnostics()) {
                    log.warn(d);
                }
                throw new RuntimeException("Compilation failed!");
            }
            catch (Exception e) {
                throw new RuntimeException("Compilation failed", e);
            }
        }
    }

    public String resolveMainClassName() {
        return this.javaSourceContext.getClassName();
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] bytecode = this.getClassBytes(name);
        if (bytecode == null) {
            throw new ClassNotFoundException(name);
        }
        return this.defineClass(name, bytecode, 0, bytecode.length);
    }

    public byte[] getClassBytes(String name) {
        return this.fileManager.getCompiledClass(name);
    }
}

