/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.codegen.annotations.CacheReturn;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.core.impl.Arguments;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.Address;
import io.vertx.core.net.impl.SocketAddressImpl;
import java.net.InetSocketAddress;

@DataObject
public interface SocketAddress
extends Address {
    public static SocketAddress fromJson(JsonObject json) {
        Integer port = json.getInteger("port");
        String host = json.getString("host");
        if (host != null && port != null) {
            if (port >= 0) {
                return SocketAddress.inetSocketAddress(port, host);
            }
            return SocketAddress.sharedRandomPort(-port.intValue(), host);
        }
        String path = json.getString("path");
        if (path != null) {
            return SocketAddress.domainSocketAddress(path);
        }
        return null;
    }

    public static SocketAddress sharedRandomPort(int id, String host) {
        if (id < 1) {
            throw new IllegalArgumentException("Shared random port ID " + id + " must be > 0");
        }
        return new SocketAddressImpl(-id, host);
    }

    public static SocketAddress inetSocketAddress(int port, String host) {
        Arguments.requireInRange(port, 0, 65535, "port p must be in range 0 <= p <= 65535");
        return new SocketAddressImpl(port, host);
    }

    public static SocketAddress domainSocketAddress(String path) {
        return new SocketAddressImpl(path);
    }

    @GenIgnore(value={"permitted-type"})
    public static SocketAddress inetSocketAddress(InetSocketAddress address) {
        return new SocketAddressImpl(address);
    }

    @CacheReturn
    public String host();

    @CacheReturn
    public String hostName();

    @CacheReturn
    public String hostAddress();

    @CacheReturn
    public int port();

    @CacheReturn
    public String path();

    @CacheReturn
    public boolean isInetSocket();

    @CacheReturn
    public boolean isDomainSocket();

    default public JsonObject toJson() {
        if (this.isInetSocket()) {
            return new JsonObject().put("host", this.host()).put("port", this.port());
        }
        if (this.isDomainSocket()) {
            return new JsonObject().put("path", this.path());
        }
        throw new IllegalStateException();
    }
}

