/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpFrame;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.impl.HttpClientConnectionInternal;
import io.vertx.core.http.impl.HttpClientPush;
import io.vertx.core.http.impl.HttpClientStream;
import io.vertx.core.http.impl.HttpRequestHead;
import io.vertx.core.http.impl.HttpResponseHead;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.net.endpoint.ServerInteraction;
import io.vertx.core.streams.WriteStream;

class StatisticsGatheringHttpClientStream
implements HttpClientStream {
    private final HttpClientStream delegate;
    private final ServerInteraction endpointRequest;

    StatisticsGatheringHttpClientStream(HttpClientStream delegate, ServerInteraction endpointRequest) {
        this.delegate = delegate;
        this.endpointRequest = endpointRequest;
    }

    @Override
    public int id() {
        return this.delegate.id();
    }

    @Override
    public Object metric() {
        return this.delegate.metric();
    }

    @Override
    public Object trace() {
        return this.delegate.trace();
    }

    @Override
    public HttpVersion version() {
        return this.delegate.version();
    }

    @Override
    public HttpClientConnectionInternal connection() {
        return this.delegate.connection();
    }

    @Override
    public ContextInternal getContext() {
        return this.delegate.getContext();
    }

    @Override
    public Future<Void> writeHead(HttpRequestHead request, boolean chunked, ByteBuf buf, boolean end, StreamPriority priority, boolean connect) {
        this.endpointRequest.reportRequestBegin();
        if (end) {
            this.endpointRequest.reportRequestEnd();
        }
        return this.delegate.writeHead(request, chunked, buf, end, priority, connect);
    }

    @Override
    public Future<Void> writeBuffer(ByteBuf buf, boolean end) {
        if (end) {
            this.endpointRequest.reportRequestEnd();
        }
        return this.delegate.writeBuffer(buf, end);
    }

    @Override
    public Future<Void> writeFrame(int type, int flags, ByteBuf payload) {
        return this.delegate.writeFrame(type, flags, payload);
    }

    @Override
    public void continueHandler(Handler<Void> handler) {
        this.delegate.continueHandler(handler);
    }

    @Override
    public void earlyHintsHandler(Handler<MultiMap> handler) {
        this.delegate.earlyHintsHandler(handler);
    }

    @Override
    public void pushHandler(Handler<HttpClientPush> handler) {
        this.delegate.pushHandler(handler);
    }

    @Override
    public void unknownFrameHandler(Handler<HttpFrame> handler) {
        this.delegate.unknownFrameHandler(handler);
    }

    @Override
    public void headHandler(Handler<HttpResponseHead> handler) {
        if (handler != null) {
            this.delegate.headHandler(multimap -> {
                this.endpointRequest.reportResponseBegin();
                handler.handle((HttpResponseHead)multimap);
            });
        } else {
            this.delegate.headHandler(null);
        }
    }

    @Override
    public void chunkHandler(Handler<Buffer> handler) {
        this.delegate.chunkHandler(handler);
    }

    @Override
    public void endHandler(Handler<MultiMap> handler) {
        if (handler != null) {
            this.delegate.endHandler(multimap -> {
                this.endpointRequest.reportResponseEnd();
                handler.handle((MultiMap)multimap);
            });
        } else {
            this.delegate.endHandler(null);
        }
    }

    @Override
    public void priorityHandler(Handler<StreamPriority> handler) {
        this.delegate.priorityHandler(handler);
    }

    @Override
    public void closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler(handler);
    }

    @Override
    public void doSetWriteQueueMaxSize(int size) {
        this.delegate.doSetWriteQueueMaxSize(size);
    }

    @Override
    public boolean isNotWritable() {
        return this.delegate.isNotWritable();
    }

    @Override
    public void doPause() {
        this.delegate.doPause();
    }

    @Override
    public void doFetch(long amount) {
        this.delegate.doFetch(amount);
    }

    @Override
    public Future<Void> reset(Throwable cause) {
        return this.delegate.reset(cause);
    }

    @Override
    public StreamPriority priority() {
        return this.delegate.priority();
    }

    @Override
    public void updatePriority(StreamPriority streamPriority) {
        this.delegate.updatePriority(streamPriority);
    }

    @Override
    public WriteStream<Buffer> exceptionHandler(@Nullable Handler<Throwable> handler) {
        if (handler != null) {
            this.delegate.exceptionHandler(err -> {
                this.endpointRequest.reportFailure((Throwable)err);
                handler.handle((Throwable)err);
            });
        } else {
            this.delegate.exceptionHandler((Handler)null);
        }
        return this;
    }

    @Override
    @Fluent
    public WriteStream<Buffer> setWriteQueueMaxSize(int maxSize) {
        return this.delegate.setWriteQueueMaxSize(maxSize);
    }

    @Override
    public boolean writeQueueFull() {
        return this.delegate.writeQueueFull();
    }

    @Override
    @Fluent
    public WriteStream<Buffer> drainHandler(@Nullable Handler<Void> handler) {
        return this.delegate.drainHandler(handler);
    }
}

