/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.internal.resource;

public abstract class ManagedResource {
    Runnable cleaner;
    private boolean shutdown;
    private boolean closed;
    private boolean disposed;
    private long acquireInProgress;
    private long refCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean before() {
        ManagedResource managedResource = this;
        synchronized (managedResource) {
            if (this.disposed) {
                return false;
            }
            ++this.acquireInProgress;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void after() {
        boolean dispose;
        ManagedResource managedResource = this;
        synchronized (managedResource) {
            --this.acquireInProgress;
            dispose = this.checkDispose();
        }
        if (dispose) {
            this.disposeInternal();
        }
    }

    protected void checkExpired() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean incRefCount() {
        ManagedResource managedResource = this;
        synchronized (managedResource) {
            ++this.refCount;
            return !this.closed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean decRefCount() {
        ManagedResource managedResource = this;
        synchronized (managedResource) {
            --this.refCount;
            if (!this.checkDispose()) {
                return false;
            }
        }
        this.disposeInternal();
        return true;
    }

    private void disposeInternal() {
        this.cleaner.run();
        this.cleanup();
    }

    private boolean checkDispose() {
        if (!this.disposed && this.refCount == 0L && this.acquireInProgress == 0L) {
            this.disposed = true;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void close() {
        this.shutdown();
        ManagedResource managedResource = this;
        synchronized (managedResource) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        this.handleClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void shutdown() {
        ManagedResource managedResource = this;
        synchronized (managedResource) {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
        }
        this.handleShutdown();
    }

    protected void cleanup() {
    }

    protected void handleShutdown() {
    }

    protected void handleClose() {
    }
}

