/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.internal.tls;

import io.netty.handler.ssl.SslContext;
import io.netty.util.AsyncMapping;
import io.vertx.core.VertxException;
import io.vertx.core.http.ClientAuth;
import io.vertx.core.internal.net.VertxSslContext;
import io.vertx.core.internal.tls.SslContextManager;
import io.vertx.core.internal.tls.VertxTrustManagerFactory;
import io.vertx.core.spi.tls.SslContextFactory;
import java.security.cert.CRL;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SslContextProvider {
    private final boolean useWorkerPool;
    private final Supplier<SslContextFactory> provider;
    private final Set<String> enabledProtocols;
    private final List<CRL> crls;
    private final ClientAuth clientAuth;
    private final Set<String> enabledCipherSuites;
    private final List<String> applicationProtocols;
    private final String endpointIdentificationAlgorithm;
    private final KeyManagerFactory keyManagerFactory;
    private final TrustManagerFactory trustManagerFactory;
    private final Function<String, KeyManagerFactory> keyManagerFactoryMapper;
    private final Function<String, TrustManager[]> trustManagerMapper;
    private final SslContext[] sslContexts = new SslContext[2];
    private final Map<String, SslContext>[] sslContextMaps = new Map[]{new ConcurrentHashMap(), new ConcurrentHashMap()};

    private static int idx(boolean useAlpn) {
        return useAlpn ? 0 : 1;
    }

    public SslContextProvider(boolean useWorkerPool, ClientAuth clientAuth, String endpointIdentificationAlgorithm, List<String> applicationProtocols, Set<String> enabledCipherSuites, Set<String> enabledProtocols, KeyManagerFactory keyManagerFactory, Function<String, KeyManagerFactory> keyManagerFactoryMapper, TrustManagerFactory trustManagerFactory, Function<String, TrustManager[]> trustManagerMapper, List<CRL> crls, Supplier<SslContextFactory> provider) {
        this.useWorkerPool = useWorkerPool;
        this.provider = provider;
        this.clientAuth = clientAuth;
        this.endpointIdentificationAlgorithm = endpointIdentificationAlgorithm;
        this.applicationProtocols = applicationProtocols;
        this.enabledCipherSuites = new HashSet<String>(enabledCipherSuites);
        this.enabledProtocols = enabledProtocols;
        this.keyManagerFactory = keyManagerFactory;
        this.trustManagerFactory = trustManagerFactory;
        this.keyManagerFactoryMapper = keyManagerFactoryMapper;
        this.trustManagerMapper = trustManagerMapper;
        this.crls = crls;
    }

    public boolean useWorkerPool() {
        return this.useWorkerPool;
    }

    public int sniEntrySize() {
        return this.sslContextMaps[0].size() + this.sslContextMaps[1].size();
    }

    public VertxSslContext createContext(boolean server, KeyManagerFactory keyManagerFactory, TrustManager[] trustManagers, String serverName, boolean useAlpn) {
        if (keyManagerFactory == null) {
            keyManagerFactory = this.defaultKeyManagerFactory();
        }
        if (trustManagers == null) {
            trustManagers = this.defaultTrustManagers();
        }
        if (server) {
            return this.createServerContext(keyManagerFactory, trustManagers, serverName, useAlpn);
        }
        return this.createClientContext(keyManagerFactory, trustManagers, serverName, useAlpn);
    }

    public SslContext sslClientContext(String serverName, boolean useAlpn) {
        try {
            return this.sslContext(serverName, useAlpn, false);
        }
        catch (Exception e) {
            throw new VertxException(e);
        }
    }

    public SslContext sslContext(String serverName, boolean useAlpn, boolean server) throws Exception {
        int idx = SslContextProvider.idx(useAlpn);
        if (serverName != null) {
            KeyManagerFactory kmf = this.resolveKeyManagerFactory(serverName);
            TrustManager[] trustManagers = this.resolveTrustManagers(serverName);
            if (kmf != null || trustManagers != null || !server) {
                return this.sslContextMaps[idx].computeIfAbsent(serverName, s -> this.createContext(server, kmf, trustManagers, (String)s, useAlpn));
            }
        }
        if (this.sslContexts[idx] == null) {
            VertxSslContext context = this.createContext(server, null, null, serverName, useAlpn);
            this.sslContexts[idx] = context;
        }
        return this.sslContexts[idx];
    }

    public SslContext sslServerContext(boolean useAlpn) {
        try {
            return this.sslContext(null, useAlpn, true);
        }
        catch (Exception e) {
            throw new VertxException(e);
        }
    }

    public AsyncMapping<? super String, ? extends SslContext> serverNameMapping(Executor workerPool, boolean useAlpn) {
        return (serverName, promise) -> {
            workerPool.execute(() -> {
                SslContext sslContext;
                try {
                    sslContext = this.sslContext((String)serverName, useAlpn, true);
                }
                catch (Exception e) {
                    promise.setFailure((Throwable)e);
                    return;
                }
                promise.setSuccess((Object)sslContext);
            });
            return promise;
        };
    }

    public VertxSslContext createContext(boolean server, boolean useAlpn) {
        return this.createContext(server, this.defaultKeyManagerFactory(), this.defaultTrustManagers(), null, useAlpn);
    }

    public VertxSslContext createClientContext(KeyManagerFactory keyManagerFactory, TrustManager[] trustManagers, final String serverName, boolean useAlpn) {
        try {
            SslContextFactory factory = this.provider.get().useAlpn(useAlpn).forClient(true).enabledCipherSuites(this.enabledCipherSuites).applicationProtocols(this.applicationProtocols);
            if (keyManagerFactory != null) {
                factory.keyMananagerFactory(keyManagerFactory);
            }
            if (trustManagers != null) {
                VertxTrustManagerFactory tmf = this.buildVertxTrustManagerFactory(trustManagers);
                factory.trustManagerFactory(tmf);
            }
            SslContext context = factory.create();
            return new VertxSslContext(context){

                protected void initEngine(SSLEngine engine) {
                    SslContextProvider.this.configureEngine(engine, SslContextProvider.this.enabledProtocols, serverName, true);
                }
            };
        }
        catch (Exception e) {
            throw new VertxException(e);
        }
    }

    public VertxSslContext createServerContext(KeyManagerFactory keyManagerFactory, TrustManager[] trustManagers, final String serverName, boolean useAlpn) {
        try {
            SslContextFactory factory = this.provider.get().useAlpn(useAlpn).forClient(false).enabledCipherSuites(this.enabledCipherSuites).applicationProtocols(this.applicationProtocols);
            factory.clientAuth(SslContextManager.CLIENT_AUTH_MAPPING.get((Object)this.clientAuth));
            if (serverName != null) {
                factory.serverName(serverName);
            }
            if (keyManagerFactory != null) {
                factory.keyMananagerFactory(keyManagerFactory);
            }
            if (trustManagers != null) {
                VertxTrustManagerFactory tmf = this.buildVertxTrustManagerFactory(trustManagers);
                factory.trustManagerFactory(tmf);
            }
            SslContext context = factory.create();
            return new VertxSslContext(context){

                protected void initEngine(SSLEngine engine) {
                    SslContextProvider.this.configureEngine(engine, SslContextProvider.this.enabledProtocols, serverName, false);
                }
            };
        }
        catch (Exception e) {
            throw new VertxException(e);
        }
    }

    public TrustManager[] defaultTrustManagers() {
        return this.trustManagerFactory != null ? this.trustManagerFactory.getTrustManagers() : null;
    }

    public TrustManagerFactory defaultTrustManagerFactory() {
        return this.trustManagerFactory;
    }

    public KeyManagerFactory defaultKeyManagerFactory() {
        return this.keyManagerFactory;
    }

    public KeyManagerFactory resolveKeyManagerFactory(String serverName) throws Exception {
        if (this.keyManagerFactoryMapper != null) {
            return this.keyManagerFactoryMapper.apply(serverName);
        }
        return null;
    }

    public TrustManager[] resolveTrustManagers(String serverName) throws Exception {
        if (this.trustManagerMapper != null) {
            return this.trustManagerMapper.apply(serverName);
        }
        return null;
    }

    private VertxTrustManagerFactory buildVertxTrustManagerFactory(TrustManager[] mgrs) {
        if (this.crls != null && this.crls.size() > 0) {
            mgrs = SslContextProvider.createUntrustRevokedCertTrustManager(mgrs, this.crls);
        }
        return new VertxTrustManagerFactory(mgrs);
    }

    private static TrustManager[] createUntrustRevokedCertTrustManager(TrustManager[] trustMgrs, final List<CRL> crls) {
        trustMgrs = (TrustManager[])trustMgrs.clone();
        for (int i = 0; i < trustMgrs.length; ++i) {
            TrustManager trustMgr = trustMgrs[i];
            if (!(trustMgr instanceof X509TrustManager)) continue;
            final X509TrustManager x509TrustManager = (X509TrustManager)trustMgr;
            trustMgrs[i] = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    this.checkRevoked(x509Certificates);
                    x509TrustManager.checkClientTrusted(x509Certificates, s);
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    this.checkRevoked(x509Certificates);
                    x509TrustManager.checkServerTrusted(x509Certificates, s);
                }

                private void checkRevoked(X509Certificate[] x509Certificates) throws CertificateException {
                    for (X509Certificate cert : x509Certificates) {
                        for (CRL crl : crls) {
                            if (!crl.isRevoked(cert)) continue;
                            throw new CertificateException("Certificate revoked");
                        }
                    }
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return x509TrustManager.getAcceptedIssuers();
                }
            };
        }
        return trustMgrs;
    }

    public void configureEngine(SSLEngine engine, Set<String> enabledProtocols, String serverName, boolean client) {
        SSLParameters sslParameters;
        LinkedHashSet<String> protocols = new LinkedHashSet<String>(enabledProtocols);
        protocols.retainAll(Arrays.asList(engine.getSupportedProtocols()));
        engine.setEnabledProtocols(protocols.toArray(new String[protocols.size()]));
        if (client) {
            sslParameters = engine.getSSLParameters();
            sslParameters.setEndpointIdentificationAlgorithm(this.endpointIdentificationAlgorithm != null ? this.endpointIdentificationAlgorithm : "");
            engine.setSSLParameters(sslParameters);
        }
        if (serverName != null) {
            sslParameters = engine.getSSLParameters();
            sslParameters.setServerNames(Collections.singletonList(new SNIHostName(serverName)));
            engine.setSSLParameters(sslParameters);
        }
    }
}

