/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.internal.streams;

import io.vertx.core.Handler;
import io.vertx.core.VertxException;
import io.vertx.core.impl.Utils;
import io.vertx.core.impl.WorkerExecutor;
import io.vertx.core.streams.ReadStream;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ReadStreamIterator<E>
implements Iterator<E>,
Handler<E> {
    private static final Throwable END_SENTINEL = new VertxException("", true);
    private final ReadStream<E> stream;
    private final Queue<Object> queue;
    private final Lock lock;
    private final Condition consumerProgress;
    private Throwable ended;

    public static <E> Iterator<E> iterator(ReadStream<E> stream) {
        ReadStreamIterator<E> iterator = new ReadStreamIterator<E>(stream);
        iterator.init();
        return iterator;
    }

    public ReadStreamIterator(ReadStream<E> stream) {
        this.stream = stream;
        this.queue = new ArrayDeque<Object>();
        this.lock = new ReentrantLock();
        this.consumerProgress = this.lock.newCondition();
    }

    void init() {
        this.stream.handler(this);
        this.stream.exceptionHandler(this::handleEnd);
        this.stream.endHandler(v -> this.handleEnd(END_SENTINEL));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(E elt) {
        this.lock.lock();
        try {
            boolean pause;
            int size = this.queue.size();
            boolean bl = pause = size == 15;
            if (pause) {
                this.stream.pause();
                this.queue.add(new Resume(elt));
            } else {
                this.queue.add(elt);
            }
            this.consumerProgress.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void handleEnd(Throwable cause) {
        try {
            this.stream.endHandler(null);
            this.stream.exceptionHandler((Handler)null);
            this.stream.handler(null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.lock.lock();
        try {
            this.ended = cause;
            this.consumerProgress.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean hasNext() {
        this.lock.lock();
        try {
            while (true) {
                if (!this.queue.isEmpty()) {
                    boolean bl = true;
                    return bl;
                }
                if (this.ended != null) {
                    boolean bl = this.ended != END_SENTINEL;
                    return bl;
                }
                this.awaitProgress();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void awaitProgress() {
        WorkerExecutor executor = WorkerExecutor.unwrapWorkerExecutor();
        if (executor != null) {
            WorkerExecutor.Execution execution = executor.currentExecution();
            CountDownLatch latch = execution.trySuspend();
            try {
                this.consumerProgress.await();
                this.lock.unlock();
                execution.resume();
                latch.await();
                this.lock.lock();
            }
            catch (InterruptedException e) {
                Utils.throwAsUnchecked(e);
            }
        } else {
            try {
                this.consumerProgress.await();
            }
            catch (InterruptedException e) {
                Utils.throwAsUnchecked(e);
            }
        }
    }

    @Override
    public E next() {
        Object elt;
        this.lock.lock();
        try {
            while ((elt = this.queue.poll()) == null) {
                Throwable t = this.ended;
                if (t != null) {
                    if (t == END_SENTINEL) {
                        throw new NoSuchElementException();
                    }
                    Utils.throwAsUnchecked(t);
                }
                this.awaitProgress();
            }
        }
        finally {
            this.lock.unlock();
        }
        if (elt instanceof Resume) {
            elt = ((Resume)elt).elt;
            this.stream.resume();
        }
        return (E)elt;
    }

    static class Resume {
        final Object elt;

        public Resume(Object elt) {
            this.elt = elt;
        }
    }
}

