/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.LastHttpContent;
import io.vertx.core.http.impl.AssembledHttpObject;

class AssembledLastHttpContent
extends AssembledHttpObject
implements LastHttpContent {
    private final HttpHeaders trailingHeaders;
    private DecoderResult result;
    private ByteBuf content;

    AssembledLastHttpContent(ByteBuf content, HttpHeaders trailingHeaders) {
        this(content, trailingHeaders, DecoderResult.SUCCESS);
    }

    AssembledLastHttpContent(ByteBuf content, HttpHeaders trailingHeaders, DecoderResult result) {
        super(true);
        this.trailingHeaders = trailingHeaders;
        this.result = result;
        this.content = content;
    }

    public HttpHeaders trailingHeaders() {
        return this.trailingHeaders;
    }

    public LastHttpContent copy() {
        throw new UnsupportedOperationException();
    }

    public LastHttpContent retain(int increment) {
        this.content.retain(increment);
        return this;
    }

    public LastHttpContent retain() {
        this.content.retain();
        return this;
    }

    public ByteBuf content() {
        return this.content;
    }

    public int refCnt() {
        return this.content.refCnt();
    }

    public boolean release() {
        return this.content.release();
    }

    public boolean release(int decrement) {
        return this.content.release(decrement);
    }

    public LastHttpContent duplicate() {
        throw new UnsupportedOperationException();
    }

    public LastHttpContent replace(ByteBuf content) {
        throw new UnsupportedOperationException();
    }

    public LastHttpContent retainedDuplicate() {
        throw new UnsupportedOperationException();
    }

    public DecoderResult decoderResult() {
        return this.result;
    }

    public DecoderResult getDecoderResult() {
        return this.result;
    }

    public void setDecoderResult(DecoderResult result) {
        this.result = result;
    }

    public AssembledLastHttpContent touch() {
        this.content.touch();
        return this;
    }

    public AssembledLastHttpContent touch(Object hint) {
        this.content.touch(hint);
        return this;
    }
}

