/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.eventbus;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.eventbus.DeliveryContext;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.eventbus.MessageConsumerOptions;
import io.vertx.core.eventbus.MessageProducer;
import io.vertx.core.eventbus.impl.DefaultSerializableChecker;
import io.vertx.core.metrics.Measured;
import java.util.function.Function;

@VertxGen
public interface EventBus
extends Measured {
    @GenIgnore
    public static final Function<String, Boolean> DEFAULT_SERIALIZABLE_CHECKER = DefaultSerializableChecker.INSTANCE::check;

    @Fluent
    public EventBus send(String var1, @Nullable Object var2);

    @Fluent
    public EventBus send(String var1, @Nullable Object var2, DeliveryOptions var3);

    default public <T> Future<Message<T>> request(String address, @Nullable Object message) {
        return this.request(address, message, new DeliveryOptions());
    }

    public <T> Future<Message<T>> request(String var1, @Nullable Object var2, DeliveryOptions var3);

    @Fluent
    public EventBus publish(String var1, @Nullable Object var2);

    @Fluent
    public EventBus publish(String var1, @Nullable Object var2, DeliveryOptions var3);

    public <T> MessageConsumer<T> consumer(MessageConsumerOptions var1);

    public <T> MessageConsumer<T> consumer(MessageConsumerOptions var1, Handler<Message<T>> var2);

    public <T> MessageConsumer<T> consumer(String var1);

    public <T> MessageConsumer<T> consumer(String var1, Handler<Message<T>> var2);

    public <T> MessageConsumer<T> localConsumer(String var1);

    public <T> MessageConsumer<T> localConsumer(String var1, Handler<Message<T>> var2);

    public <T> MessageProducer<T> sender(String var1);

    public <T> MessageProducer<T> sender(String var1, DeliveryOptions var2);

    public <T> MessageProducer<T> publisher(String var1);

    public <T> MessageProducer<T> publisher(String var1, DeliveryOptions var2);

    @Fluent
    @GenIgnore(value={"permitted-type"})
    public EventBus registerCodec(MessageCodec var1);

    @Fluent
    @GenIgnore(value={"permitted-type"})
    public EventBus unregisterCodec(String var1);

    @Fluent
    @GenIgnore
    public <T> EventBus registerDefaultCodec(Class<T> var1, MessageCodec<T, ?> var2);

    @Fluent
    @GenIgnore
    public EventBus unregisterDefaultCodec(Class var1);

    @Fluent
    public EventBus codecSelector(Function<Object, String> var1);

    @Fluent
    public <T> EventBus addOutboundInterceptor(Handler<DeliveryContext<T>> var1);

    @Fluent
    public <T> EventBus removeOutboundInterceptor(Handler<DeliveryContext<T>> var1);

    @Fluent
    public <T> EventBus addInboundInterceptor(Handler<DeliveryContext<T>> var1);

    @Fluent
    public <T> EventBus removeInboundInterceptor(Handler<DeliveryContext<T>> var1);

    @Fluent
    public EventBus clusterSerializableChecker(Function<String, Boolean> var1);

    @Fluent
    public EventBus serializableChecker(Function<String, Boolean> var1);
}

