/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.endpoint.impl;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.internal.net.endpoint.EndpointResolverInternal;
import io.vertx.core.internal.resource.ManagedResource;
import io.vertx.core.internal.resource.ResourceManager;
import io.vertx.core.net.Address;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.endpoint.Endpoint;
import io.vertx.core.net.endpoint.InteractionMetrics;
import io.vertx.core.net.endpoint.LoadBalancer;
import io.vertx.core.net.endpoint.ServerEndpoint;
import io.vertx.core.net.endpoint.ServerInteraction;
import io.vertx.core.net.endpoint.ServerSelector;
import io.vertx.core.spi.endpoint.EndpointBuilder;
import io.vertx.core.spi.endpoint.EndpointResolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.Function;

public class EndpointResolverImpl<S, A extends Address, N>
implements EndpointResolverInternal {
    private final VertxInternal vertx;
    private final LoadBalancer loadBalancer;
    private final EndpointResolver<A, N, S, ListOfServers> endpointResolver;
    private final ResourceManager<A, ManagedEndpoint> endpointManager;
    private final long expirationMillis;
    private final Function<A, ManagedEndpoint> provider = key -> {
        Future<EndpointImpl> holder = this.resolve(key);
        ManagedEndpoint endpoint = new ManagedEndpoint(holder);
        endpoint.incRefCount();
        return endpoint;
    };
    private final BiFunction<ManagedEndpoint, Boolean, Result> fn = (endpoint, created) -> new Result(endpoint.endpoint, (ManagedEndpoint)endpoint, (boolean)created);

    public EndpointResolverImpl(VertxInternal vertx, EndpointResolver<A, N, S, ?> endpointResolver, LoadBalancer loadBalancer, long expirationMillis) {
        if (loadBalancer == null) {
            loadBalancer = LoadBalancer.ROUND_ROBIN;
        }
        this.vertx = vertx;
        this.loadBalancer = loadBalancer;
        this.endpointResolver = endpointResolver;
        this.endpointManager = new ResourceManager();
        this.expirationMillis = expirationMillis;
    }

    @Override
    public void checkExpired() {
        this.endpointManager.checkExpired();
    }

    @Override
    public Future<Endpoint> resolveEndpoint(Address address) {
        return this.vertx.future(promise -> this.lookupEndpoint(address, (Promise<Endpoint>)promise));
    }

    @Override
    public void lookupEndpoint(Address address, Promise<Endpoint> promise) {
        A casted = this.endpointResolver.tryCast(address);
        if (casted == null) {
            promise.fail("Cannot resolve address " + String.valueOf(address));
            return;
        }
        ManagedEndpoint resolved = this.resolveAddress(casted);
        resolved.endpoint.onComplete(promise);
    }

    private ManagedEndpoint resolveAddress(A address) {
        Result sFuture = this.endpointManager.withResource(address, this.provider, managedEndpoint -> {
            Future<EndpointImpl> fut = managedEndpoint.endpoint;
            if (fut.succeeded()) {
                EndpointImpl endpoint = fut.result();
                return this.endpointResolver.isValid(endpoint.state);
            }
            return true;
        }, this.fn);
        if (sFuture.created) {
            sFuture.fut.onFailure(err -> {
                if (sFuture.endpoint.disposed.compareAndSet(false, true)) {
                    sFuture.endpoint.decRefCount();
                }
            });
        }
        return sFuture.endpoint;
    }

    private Future<EndpointImpl> resolve(A address) {
        final AtomicLong lastAccessed = new AtomicLong(System.currentTimeMillis());
        EndpointBuilder builder = new EndpointBuilder<ListOfServers, N>(){

            @Override
            public EndpointBuilder<ListOfServers, N> addServer(N server, String key) {
                final ArrayList<ServerEndpointImpl> list = new ArrayList<ServerEndpointImpl>();
                InteractionMetrics<?> metrics = EndpointResolverImpl.this.loadBalancer.newMetrics();
                list.add(new ServerEndpointImpl(lastAccessed, key, server, metrics));
                return new EndpointBuilder<ListOfServers, N>(){

                    @Override
                    public EndpointBuilder<ListOfServers, N> addServer(N server, String key) {
                        InteractionMetrics<?> metrics = EndpointResolverImpl.this.loadBalancer.newMetrics();
                        list.add(new ServerEndpointImpl(lastAccessed, key, server, metrics));
                        return this;
                    }

                    @Override
                    public ListOfServers build() {
                        return new ListOfServers(list, EndpointResolverImpl.this.loadBalancer.selector(list));
                    }
                };
            }

            @Override
            public ListOfServers build() {
                return new ListOfServers(Collections.emptyList(), () -> -1);
            }
        };
        return this.endpointResolver.resolve(address, builder).map(s -> new EndpointImpl(this, address, lastAccessed, s));
    }

    public class ServerEndpointImpl
    implements ServerEndpoint {
        final AtomicLong lastAccessed;
        final String key;
        final N endpoint;
        final InteractionMetrics<?> metrics;

        public ServerEndpointImpl(AtomicLong lastAccessed, String key, N endpoint, InteractionMetrics<?> metrics) {
            this.lastAccessed = lastAccessed;
            this.key = key;
            this.endpoint = endpoint;
            this.metrics = metrics;
        }

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public Object unwrap() {
            return this.endpoint;
        }

        @Override
        public InteractionMetrics<?> metrics() {
            return this.metrics;
        }

        @Override
        public SocketAddress address() {
            return EndpointResolverImpl.this.endpointResolver.addressOf(this.endpoint);
        }

        @Override
        public ServerInteraction newInteraction() {
            this.lastAccessed.set(System.currentTimeMillis());
            final InteractionMetrics<?> metrics = this.metrics;
            final Object metric = metrics.initiateRequest();
            return new ServerInteraction(){

                @Override
                public void reportRequestBegin() {
                    metrics.reportRequestBegin(metric);
                }

                @Override
                public void reportRequestEnd() {
                    metrics.reportRequestEnd(metric);
                }

                @Override
                public void reportResponseBegin() {
                    metrics.reportResponseBegin(metric);
                }

                @Override
                public void reportResponseEnd() {
                    metrics.reportResponseEnd(metric);
                }

                @Override
                public void reportFailure(Throwable failure) {
                    metrics.reportFailure(metric, failure);
                }
            };
        }

        public String toString() {
            return String.valueOf(this.endpoint);
        }
    }

    private static class ListOfServers
    implements Iterable<ServerEndpoint> {
        final List<ServerEndpoint> servers;
        final ServerSelector selector;

        private ListOfServers(List<ServerEndpoint> servers, ServerSelector selector) {
            this.servers = servers;
            this.selector = selector;
        }

        @Override
        public Iterator<ServerEndpoint> iterator() {
            return this.servers.iterator();
        }

        public String toString() {
            return this.servers.toString();
        }
    }

    private class Result {
        final Future<EndpointImpl> fut;
        final ManagedEndpoint endpoint;
        final boolean created;

        public Result(Future<EndpointImpl> fut, ManagedEndpoint endpoint, boolean created) {
            this.fut = fut;
            this.endpoint = endpoint;
            this.created = created;
        }
    }

    private class ManagedEndpoint
    extends ManagedResource {
        private final Future<EndpointImpl> endpoint;
        private final AtomicBoolean disposed = new AtomicBoolean();
        private boolean valid;

        public ManagedEndpoint(Future<EndpointImpl> endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        protected void cleanup() {
            if (this.endpoint.succeeded()) {
                this.endpoint.result().close();
            }
        }

        @Override
        protected void checkExpired() {
            if (this.endpoint.succeeded() && EndpointResolverImpl.this.expirationMillis > 0L && System.currentTimeMillis() - this.endpoint.result().lastAccessed.get() >= EndpointResolverImpl.this.expirationMillis && this.disposed.compareAndSet(false, true)) {
                this.decRefCount();
            }
        }

        @Override
        public boolean incRefCount() {
            return super.incRefCount();
        }

        @Override
        public boolean decRefCount() {
            return super.decRefCount();
        }
    }

    private static class EndpointImpl
    implements Endpoint {
        private final AtomicLong lastAccessed;
        private final A address;
        private final S state;
        final /* synthetic */ EndpointResolverImpl this$0;

        public EndpointImpl(A address, AtomicLong lastAccessed, S state) {
            this.this$0 = var1_1;
            this.state = state;
            this.address = address;
            this.lastAccessed = lastAccessed;
        }

        @Override
        public List<ServerEndpoint> servers() {
            return this.this$0.endpointResolver.endpoint(this.state).servers;
        }

        public void close() {
            this.this$0.endpointResolver.dispose(this.state);
        }

        private ServerEndpoint selectEndpoint(S state, String routingKey) {
            ListOfServers listOfServers = this.this$0.endpointResolver.endpoint(state);
            int idx = routingKey == null ? listOfServers.selector.select() : listOfServers.selector.select(routingKey);
            if (idx >= 0 && idx < listOfServers.servers.size()) {
                return listOfServers.servers.get(idx);
            }
            return null;
        }

        @Override
        public ServerEndpoint selectServer(String key) {
            ServerEndpoint endpoint = this.selectEndpoint(this.state, key);
            if (endpoint == null) {
                throw new IllegalStateException("No results for " + String.valueOf(this.address));
            }
            return endpoint;
        }
    }
}

