/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.transports;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.IoHandlerFactory;
import io.netty.channel.ServerChannel;
import io.netty.channel.nio.NioIoHandler;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioDomainSocketChannel;
import io.netty.channel.socket.nio.NioServerDomainSocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.vertx.core.impl.transports.UnixDomainSocketNioTransport;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.transport.Transport;

public class NioTransport
implements Transport {
    public static final Transport INSTANCE = new NioTransport();
    private final UnixDomainSocketNioTransport unixDomainSocketNioTransport = UnixDomainSocketNioTransport.load();

    @Override
    public boolean supportsDomainSockets() {
        return this.unixDomainSocketNioTransport != null;
    }

    @Override
    public java.net.SocketAddress convert(SocketAddress address) {
        if (address.isDomainSocket() && this.unixDomainSocketNioTransport != null) {
            return this.unixDomainSocketNioTransport.convert(address);
        }
        return Transport.super.convert(address);
    }

    @Override
    public SocketAddress convert(java.net.SocketAddress address) {
        if (this.unixDomainSocketNioTransport != null && this.unixDomainSocketNioTransport.isUnixDomainSocketAddress(address)) {
            return this.unixDomainSocketNioTransport.convert(address);
        }
        return Transport.super.convert(address);
    }

    @Override
    public IoHandlerFactory ioHandlerFactory() {
        return NioIoHandler.newFactory();
    }

    @Override
    public DatagramChannel datagramChannel() {
        return new NioDatagramChannel();
    }

    @Override
    public DatagramChannel datagramChannel(InternetProtocolFamily family) {
        switch (family) {
            case IPv4: {
                return new NioDatagramChannel(InternetProtocolFamily.IPv4);
            }
            case IPv6: {
                return new NioDatagramChannel(InternetProtocolFamily.IPv6);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public ChannelFactory<? extends Channel> channelFactory(boolean domainSocket) {
        if (domainSocket) {
            if (this.unixDomainSocketNioTransport == null) {
                throw new IllegalArgumentException("Domain sockets require JDK 16 and above, or the usage of a native transport");
            }
            return NioDomainSocketChannel::new;
        }
        return NioSocketChannel::new;
    }

    @Override
    public ChannelFactory<? extends ServerChannel> serverChannelFactory(boolean domainSocket) {
        if (domainSocket) {
            if (this.unixDomainSocketNioTransport == null) {
                throw new IllegalArgumentException("Domain sockets require JDK 16 and above, or the usage of a native transport");
            }
            return NioServerDomainSocketChannel::new;
        }
        return NioServerSocketChannel::new;
    }
}

