/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.future;

import io.vertx.core.Completable;
import io.vertx.core.Future;
import io.vertx.core.impl.future.FutureBase;
import io.vertx.core.impl.future.Operation;
import io.vertx.core.internal.ContextInternal;
import java.util.function.Function;

class Composition<T, U>
extends Operation<U>
implements Completable<T> {
    private final Function<? super T, Future<U>> successMapper;
    private final Function<Throwable, Future<U>> failureMapper;

    Composition(ContextInternal context, Function<? super T, Future<U>> successMapper, Function<Throwable, Future<U>> failureMapper) {
        super(context);
        this.successMapper = successMapper;
        this.failureMapper = failureMapper;
    }

    @Override
    public void complete(T result, Throwable failure) {
        FutureBase future;
        try {
            future = failure == null ? (FutureBase)this.successMapper.apply(result) : (FutureBase)this.failureMapper.apply(failure);
        }
        catch (Throwable e) {
            this.handleInternal(null, e);
            return;
        }
        future.addListener(this::handleInternal);
    }
}

