/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.vertx.core.Closeable;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpConnectOptions;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.internal.CloseSequence;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.internal.net.NetClientInternal;
import io.vertx.core.net.ClientSSLOptions;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.NetClientBuilder;
import io.vertx.core.net.impl.ProxyFilter;
import io.vertx.core.spi.metrics.HttpClientMetrics;
import io.vertx.core.spi.metrics.Metrics;
import io.vertx.core.spi.metrics.MetricsProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class HttpClientBase
implements MetricsProvider,
Closeable {
    protected final VertxInternal vertx;
    final HttpClientOptions options;
    protected final NetClientInternal netClient;
    protected final List<String> alpnVersions;
    protected final HttpClientMetrics metrics;
    protected final CloseSequence closeSequence;
    private volatile ClientSSLOptions defaultSslOptions;
    private long closeTimeout = 0L;
    private TimeUnit closeTimeoutUnit = TimeUnit.SECONDS;
    private Predicate<SocketAddress> proxyFilter;

    public HttpClientBase(VertxInternal vertx, HttpClientOptions options) {
        if (!options.isKeepAlive() && options.isPipelining()) {
            throw new IllegalStateException("Cannot have pipelining with no keep alive");
        }
        List<HttpVersion> alpnVersions = options.getAlpnVersions();
        if (alpnVersions == null || alpnVersions.isEmpty()) {
            switch (options.getProtocolVersion()) {
                case HTTP_2: {
                    alpnVersions = Arrays.asList(HttpVersion.HTTP_2, HttpVersion.HTTP_1_1);
                    break;
                }
                default: {
                    alpnVersions = Collections.singletonList(options.getProtocolVersion());
                    break;
                }
            }
        } else {
            alpnVersions = new ArrayList<HttpVersion>(alpnVersions);
        }
        this.alpnVersions = alpnVersions.stream().map(HttpVersion::alpnName).collect(Collectors.toUnmodifiableList());
        this.vertx = vertx;
        this.metrics = vertx.metrics() != null ? vertx.metrics().createHttpClientMetrics(options) : null;
        this.options = new HttpClientOptions(options);
        this.closeSequence = new CloseSequence(this::doClose, this::doShutdown);
        this.proxyFilter = options.getNonProxyHosts() != null ? ProxyFilter.nonProxyHosts(options.getNonProxyHosts()) : ProxyFilter.DEFAULT_PROXY_FILTER;
        this.netClient = new NetClientBuilder(vertx, new NetClientOptions(options).setProxyOptions(null)).metrics(this.metrics).build();
        this.defaultSslOptions = options.getSslOptions();
        ClientSSLOptions sslOptions = options.getSslOptions();
        if (sslOptions != null) {
            this.configureSSLOptions(sslOptions);
        }
    }

    private void configureSSLOptions(ClientSSLOptions sslOptions) {
        if (sslOptions.getHostnameVerificationAlgorithm() == null) {
            sslOptions.setHostnameVerificationAlgorithm(this.options.isVerifyHost() ? "HTTPS" : "");
        }
        if (sslOptions.getApplicationLayerProtocols() == null) {
            sslOptions.setApplicationLayerProtocols((List)this.alpnVersions);
        }
    }

    public NetClientInternal netClient() {
        return this.netClient;
    }

    public Future<Void> closeFuture() {
        return this.closeSequence.future();
    }

    @Override
    public void close(Promise<Void> completion) {
        this.closeSequence.close(completion);
    }

    protected int getPort(RequestOptions request) {
        Integer port = request.getPort();
        if (port != null) {
            return port;
        }
        SocketAddress server = (SocketAddress)request.getServer();
        if (server != null && server.isInetSocket()) {
            return server.port();
        }
        return this.options.getDefaultPort();
    }

    private ProxyOptions getProxyOptions(ProxyOptions proxyOptions) {
        if (proxyOptions == null) {
            proxyOptions = this.options.getProxyOptions();
        }
        return proxyOptions;
    }

    protected String getHost(RequestOptions request) {
        String host = request.getHost();
        if (host != null) {
            return host;
        }
        SocketAddress server = (SocketAddress)request.getServer();
        if (server != null && server.isInetSocket()) {
            return server.host();
        }
        return this.options.getDefaultHost();
    }

    protected ProxyOptions computeProxyOptions(ProxyOptions proxyOptions, SocketAddress addr) {
        proxyOptions = this.getProxyOptions(proxyOptions);
        if (this.proxyFilter != null && !this.proxyFilter.test(addr)) {
            proxyOptions = null;
        }
        return proxyOptions;
    }

    protected ClientSSLOptions sslOptions(HttpConnectOptions connectOptions) {
        ClientSSLOptions sslOptions = connectOptions.getSslOptions();
        if (sslOptions != null) {
            sslOptions = sslOptions.copy();
            this.configureSSLOptions(sslOptions);
        } else {
            sslOptions = this.defaultSslOptions;
        }
        return sslOptions;
    }

    HttpClientMetrics metrics() {
        return this.metrics;
    }

    protected void doShutdown(Promise<Void> p) {
        this.netClient.shutdown(this.closeTimeout, this.closeTimeoutUnit).onComplete(p);
    }

    protected void doClose(Promise<Void> p) {
        this.netClient.close().onComplete(p);
    }

    public Future<Void> shutdown(long timeout, TimeUnit unit) {
        this.closeTimeout = timeout;
        this.closeTimeoutUnit = unit;
        return this.closeSequence.close();
    }

    @Override
    public boolean isMetricsEnabled() {
        return this.getMetrics() != null;
    }

    @Override
    public Metrics getMetrics() {
        return this.metrics;
    }

    public Future<Boolean> updateSSLOptions(ClientSSLOptions options, boolean force) {
        options = options.copy();
        this.configureSSLOptions(options);
        this.defaultSslOptions = options;
        return Future.succeededFuture(true);
    }

    public HttpClientBase proxyFilter(Predicate<SocketAddress> filter) {
        this.proxyFilter = filter;
        return this;
    }

    public HttpClientOptions options() {
        return this.options;
    }

    public VertxInternal vertx() {
        return this.vertx;
    }

    protected void checkClosed() {
        if (this.closeSequence.started()) {
            throw new IllegalStateException("Client is closed");
        }
    }
}

