/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.dns.impl;

import io.netty.channel.EventLoop;
import io.netty.channel.socket.SocketChannel;
import io.netty.resolver.AddressResolver;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.HostsFileEntries;
import io.netty.resolver.HostsFileEntriesResolver;
import io.netty.resolver.HostsFileParser;
import io.netty.resolver.NameResolver;
import io.netty.resolver.ResolvedAddressTypes;
import io.netty.resolver.RoundRobinInetAddressResolver;
import io.netty.resolver.dns.DefaultDnsCache;
import io.netty.resolver.dns.DefaultDnsServerAddressStreamProvider;
import io.netty.resolver.dns.DnsAddressResolverGroup;
import io.netty.resolver.dns.DnsCache;
import io.netty.resolver.dns.DnsNameResolverBuilder;
import io.netty.resolver.dns.DnsServerAddressStream;
import io.netty.resolver.dns.DnsServerAddressStreamProvider;
import io.netty.resolver.dns.DnsServerAddresses;
import io.netty.util.NetUtil;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.internal.ObjectUtil;
import io.vertx.core.Future;
import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.dns.AddressResolverOptions;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.spi.dns.AddressResolverProvider;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class DnsAddressResolverProvider
implements AddressResolverProvider,
HostsFileEntriesResolver {
    private final VertxInternal vertx;
    private final List<ResolverRegistration> resolvers = Collections.synchronizedList(new ArrayList());
    private final DnsNameResolverBuilder dnsNameResolverBuilder;
    private AddressResolverGroup<InetSocketAddress> resolverGroup;
    private final List<InetSocketAddress> serverList = new ArrayList<InetSocketAddress>();
    private final String hostsPath;
    private final Buffer hostsValue;
    private final AtomicLong refreshTimestamp = new AtomicLong();
    private final long hostsRefreshPeriodNanos;
    private volatile HostsFileEntries parsedHostsFile = new HostsFileEntries(Collections.emptyMap(), Collections.emptyMap());

    public static DnsAddressResolverProvider create(VertxInternal vertx, AddressResolverOptions options) {
        DnsAddressResolverProvider provider = new DnsAddressResolverProvider(vertx, options);
        provider.refresh();
        return provider;
    }

    private DnsAddressResolverProvider(VertxInternal vertx, final AddressResolverOptions options) {
        List<String> dnsServers = options.getServers();
        if (dnsServers != null && dnsServers.size() > 0) {
            for (String dnsServer : dnsServers) {
                int port;
                String ipAddress;
                int sep = dnsServer.indexOf(58);
                if (sep != -1) {
                    ipAddress = dnsServer.substring(0, sep);
                    port = Integer.parseInt(dnsServer.substring(sep + 1));
                } else {
                    ipAddress = dnsServer;
                    port = 53;
                }
                try {
                    this.serverList.add(new InetSocketAddress(InetAddress.getByAddress(NetUtil.createByteArrayFromIpAddressString((String)ipAddress)), port));
                }
                catch (UnknownHostException e) {
                    throw new VertxException(e);
                }
            }
        } else {
            InetSocketAddress address;
            DnsServerAddressStream stream = DefaultDnsServerAddressStreamProvider.defaultAddresses().stream();
            HashSet<InetSocketAddress> all = new HashSet<InetSocketAddress>();
            while (!all.contains(address = stream.next())) {
                this.serverList.add(address);
                all.add(address);
            }
        }
        DnsServerAddresses nameServerAddresses = options.isRotateServers() ? DnsServerAddresses.rotational(this.serverList) : DnsServerAddresses.sequential(this.serverList);
        DnsServerAddressStreamProvider nameServerAddressProvider = hostname -> nameServerAddresses.stream();
        int minTtl = ObjectUtil.intValue((Integer)options.getCacheMinTimeToLive(), (int)0);
        int maxTtl = ObjectUtil.intValue((Integer)options.getCacheMaxTimeToLive(), (int)Integer.MAX_VALUE);
        int negativeTtl = ObjectUtil.intValue((Integer)options.getCacheNegativeTimeToLive(), (int)0);
        DefaultDnsCache resolveCache = new DefaultDnsCache(minTtl, maxTtl, negativeTtl);
        DefaultDnsCache authoritativeDnsServerCache = new DefaultDnsCache(minTtl, maxTtl, negativeTtl);
        this.vertx = vertx;
        this.hostsPath = options.getHostsPath();
        this.hostsValue = options.getHostsValue();
        this.hostsRefreshPeriodNanos = options.getHostsRefreshPeriod();
        DnsNameResolverBuilder builder = new DnsNameResolverBuilder();
        builder.hostsFileEntriesResolver((HostsFileEntriesResolver)this);
        builder.channelFactory(() -> vertx.transport().datagramChannel());
        builder.socketChannelFactory(() -> (SocketChannel)vertx.transport().channelFactory(false).newChannel());
        builder.nameServerProvider(nameServerAddressProvider);
        builder.queryServerAddressStream((DnsServerAddressStream)new ThreadLocalNameServerAddressStream(nameServerAddressProvider, ""));
        builder.optResourceEnabled(options.isOptResourceEnabled());
        builder.resolveCache((DnsCache)resolveCache);
        builder.authoritativeDnsServerCache((DnsCache)authoritativeDnsServerCache);
        builder.queryTimeoutMillis(options.getQueryTimeout());
        builder.maxQueriesPerResolve(options.getMaxQueries());
        builder.recursionDesired(options.getRdFlag());
        builder.completeOncePreferredResolved(true);
        builder.consolidateCacheSize(1024);
        builder.ndots(1);
        if (options.getSearchDomains() != null) {
            builder.searchDomains(options.getSearchDomains());
            int ndots = options.getNdots();
            if (ndots == -1) {
                ndots = AddressResolverOptions.DEFAULT_NDOTS;
            }
            builder.ndots(ndots);
        }
        this.dnsNameResolverBuilder = builder;
        this.resolverGroup = new DnsAddressResolverGroup(builder){

            protected AddressResolver<InetSocketAddress> newAddressResolver(EventLoop eventLoop, NameResolver<InetAddress> resolver) throws Exception {
                AddressResolver addressResolver = options.isRoundRobinInetAddress() ? new RoundRobinInetAddressResolver((EventExecutor)eventLoop, resolver).asAddressResolver() : super.newAddressResolver(eventLoop, resolver);
                DnsAddressResolverProvider.this.resolvers.add(new ResolverRegistration((AddressResolver<InetSocketAddress>)addressResolver, eventLoop));
                return addressResolver;
            }
        };
    }

    public InetAddress address(String inetHost, ResolvedAddressTypes resolvedAddressTypes) {
        InetAddress address;
        if (inetHost.endsWith(".")) {
            inetHost = inetHost.substring(0, inetHost.length() - 1);
        }
        if (this.hostsRefreshPeriodNanos > 0L) {
            this.ensureHostsFileFresh(this.hostsRefreshPeriodNanos);
        }
        if ((address = this.lookup(inetHost, resolvedAddressTypes)) == null) {
            address = this.lookup(inetHost.toLowerCase(Locale.ENGLISH), resolvedAddressTypes);
        }
        return address;
    }

    InetAddress lookup(String inetHost, ResolvedAddressTypes resolvedAddressTypes) {
        switch (resolvedAddressTypes) {
            case IPV4_ONLY: {
                return (InetAddress)this.parsedHostsFile.inet4Entries().get(inetHost);
            }
            case IPV6_ONLY: {
                return (InetAddress)this.parsedHostsFile.inet6Entries().get(inetHost);
            }
            case IPV4_PREFERRED: {
                Inet4Address inet4Address = (Inet4Address)this.parsedHostsFile.inet4Entries().get(inetHost);
                return inet4Address != null ? inet4Address : (InetAddress)this.parsedHostsFile.inet6Entries().get(inetHost);
            }
            case IPV6_PREFERRED: {
                Inet6Address inet6Address = (Inet6Address)this.parsedHostsFile.inet6Entries().get(inetHost);
                return inet6Address != null ? inet6Address : (InetAddress)this.parsedHostsFile.inet4Entries().get(inetHost);
            }
        }
        throw new IllegalArgumentException("Unknown ResolvedAddressTypes " + resolvedAddressTypes);
    }

    public DnsNameResolverBuilder getDnsNameResolverBuilder() {
        return this.dnsNameResolverBuilder;
    }

    public List<InetSocketAddress> nameServerAddresses() {
        return this.serverList;
    }

    @Override
    public AddressResolverGroup<InetSocketAddress> resolver(AddressResolverOptions options) {
        return this.resolverGroup;
    }

    @Override
    public Future<Void> close() {
        ContextInternal context = this.vertx.getOrCreateContext();
        ResolverRegistration[] registrations = this.resolvers.toArray(new ResolverRegistration[0]);
        if (registrations.length == 0) {
            return context.succeededFuture();
        }
        PromiseInternal promise = context.promise();
        AtomicInteger count = new AtomicInteger(registrations.length);
        for (ResolverRegistration registration : registrations) {
            Runnable task = () -> {
                registration.resolver.close();
                if (count.decrementAndGet() == 0) {
                    promise.complete();
                }
            };
            if (registration.executor.inEventLoop()) {
                task.run();
                continue;
            }
            registration.executor.execute(task);
        }
        return promise.future();
    }

    public void refresh() {
        this.ensureHostsFileFresh(0L);
    }

    private void ensureHostsFileFresh(long refreshPeriodNanos) {
        long prev = this.refreshTimestamp.get();
        long now = System.nanoTime();
        if (now - prev >= refreshPeriodNanos && this.refreshTimestamp.compareAndSet(prev, now)) {
            this.refreshHostsFile();
        }
    }

    private void refreshHostsFile() {
        HostsFileEntries entries;
        if (this.hostsPath != null) {
            File file = this.vertx.fileResolver().resolve(this.hostsPath).getAbsoluteFile();
            try {
                if (!file.exists() || !file.isFile()) {
                    throw new IOException();
                }
                entries = HostsFileParser.parse((File)file);
            }
            catch (IOException e) {
                throw new VertxException("Cannot read hosts file " + file.getAbsolutePath());
            }
        } else if (this.hostsValue != null) {
            try {
                entries = HostsFileParser.parse((Reader)new StringReader(this.hostsValue.toString()));
            }
            catch (IOException e) {
                throw new VertxException("Cannot read hosts config ", e);
            }
        } else {
            entries = HostsFileParser.parseSilently();
        }
        this.parsedHostsFile = entries;
    }

    private static class ThreadLocalNameServerAddressStream
    implements DnsServerAddressStream {
        private final String hostname;
        private final DnsServerAddressStreamProvider dnsServerAddressStreamProvider;
        private final ThreadLocal<DnsServerAddressStream> threadLocal = new ThreadLocal<DnsServerAddressStream>(){

            @Override
            protected DnsServerAddressStream initialValue() {
                return dnsServerAddressStreamProvider.nameServerAddressStream(hostname);
            }
        };

        ThreadLocalNameServerAddressStream(DnsServerAddressStreamProvider dnsServerAddressStreamProvider, String hostname) {
            this.dnsServerAddressStreamProvider = dnsServerAddressStreamProvider;
            this.hostname = hostname;
        }

        public InetSocketAddress next() {
            return this.threadLocal.get().next();
        }

        public DnsServerAddressStream duplicate() {
            return new ThreadLocalNameServerAddressStream(this.dnsServerAddressStreamProvider, this.hostname);
        }

        public int size() {
            return this.threadLocal.get().size();
        }
    }

    private static class ResolverRegistration {
        private final AddressResolver<InetSocketAddress> resolver;
        private final EventLoop executor;

        ResolverRegistration(AddressResolver<InetSocketAddress> resolver, EventLoop executor) {
            this.resolver = resolver;
            this.executor = executor;
        }
    }
}

