/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.internal.concurrent;

import io.netty.channel.EventLoop;
import io.vertx.core.streams.impl.MessagePassingQueue;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;

public class OutboundMessageQueue<M>
implements Predicate<M> {
    private final EventLoop eventLoop;
    private final AtomicInteger numberOfUnwritableSignals = new AtomicInteger();
    private final MessagePassingQueue.MpSc<M> mqp;
    private volatile boolean eventuallyClosed;
    private boolean overflow;
    private int draining = 0;
    private boolean closed;

    public OutboundMessageQueue(EventLoop eventLoop) {
        this.eventLoop = eventLoop;
        this.mqp = new MessagePassingQueue.MpSc(this);
    }

    public OutboundMessageQueue(EventLoop eventLoop, int lowWaterMark, int highWaterMark) {
        this.eventLoop = eventLoop;
        this.mqp = new MessagePassingQueue.MpSc(this, lowWaterMark, highWaterMark);
    }

    @Override
    public boolean test(M msg) {
        throw new UnsupportedOperationException();
    }

    public boolean isWritable() {
        return this.numberOfUnwritableSignals.get() <= 0;
    }

    public final boolean write(M message) {
        int flags;
        boolean inEventLoop = this.eventLoop.inEventLoop();
        if (inEventLoop) {
            if (this.closed) {
                this.handleDispose(message);
                return true;
            }
            flags = this.mqp.add(message);
            if (this.draining == 0 && (flags & 4) != 0) {
                flags = this.drainMessageQueue();
            }
        } else {
            if (this.eventuallyClosed) {
                this.handleDispose(message);
                return true;
            }
            flags = this.mqp.add(message);
            if ((flags & 4) != 0) {
                this.eventLoop.execute(this::drain);
            }
        }
        int val = (flags & 1) != 0 ? this.numberOfUnwritableSignals.incrementAndGet() : this.numberOfUnwritableSignals.get();
        return val <= 0;
    }

    private int drainMessageQueue() {
        ++this.draining;
        try {
            int flags = this.mqp.drain();
            this.overflow |= (flags & 4) != 0;
            if ((flags & 2) != 0) {
                this.handleDrained(MessagePassingQueue.numberOfUnwritableSignals(flags));
            }
            int n = flags;
            return n;
        }
        finally {
            --this.draining;
            if (this.draining == 0 && this.closed) {
                this.releaseMessages();
            }
        }
    }

    private void drain() {
        if (this.closed) {
            return;
        }
        assert (this.draining == 0);
        this.startDraining();
        this.drainMessageQueue();
        this.stopDraining();
    }

    public final boolean tryDrain() {
        assert (this.eventLoop.inEventLoop());
        if (this.overflow) {
            this.overflow = false;
            this.drain();
            return true;
        }
        return false;
    }

    public final void close() {
        assert (this.eventLoop.inEventLoop());
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.eventuallyClosed = true;
        if (this.draining > 0) {
            return;
        }
        this.releaseMessages();
    }

    private void handleDrained(int numberOfSignals) {
        int val = this.numberOfUnwritableSignals.addAndGet(-numberOfSignals);
        if (val + numberOfSignals > 0 && val <= 0) {
            this.eventLoop.execute(this::handleDrained);
        }
    }

    private void releaseMessages() {
        List messages = this.mqp.clear();
        for (Object elt : messages) {
            this.handleDispose(elt);
        }
    }

    protected void handleDrained() {
    }

    protected void startDraining() {
    }

    protected void stopDraining() {
    }

    protected void handleDispose(M msg) {
    }
}

