/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.netty.channel.EventLoop;
import io.vertx.core.ThreadingModel;
import io.vertx.core.impl.VertxImpl;
import io.vertx.core.internal.CloseFuture;
import io.vertx.core.internal.ContextBuilder;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.WorkerPool;
import io.vertx.core.internal.deployment.DeploymentContext;
import java.util.Objects;

public class ContextBuilderImpl
implements ContextBuilder {
    private final VertxImpl vertx;
    private ThreadingModel threadingModel;
    private EventLoop eventLoop;
    private ClassLoader classLoader;
    private CloseFuture closeFuture;
    private WorkerPool workerPool;
    private DeploymentContext deploymentContext;

    ContextBuilderImpl(VertxImpl vertx) {
        this.vertx = Objects.requireNonNull(vertx);
        this.threadingModel = ThreadingModel.EVENT_LOOP;
    }

    @Override
    public ContextBuilderImpl withThreadingModel(ThreadingModel threadingModel) {
        this.threadingModel = Objects.requireNonNull(threadingModel);
        return this;
    }

    @Override
    public ContextBuilderImpl withEventLoop(EventLoop eventLoop) {
        this.eventLoop = eventLoop;
        return this;
    }

    @Override
    public ContextBuilderImpl withClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    @Override
    public ContextBuilderImpl withCloseFuture(CloseFuture closeFuture) {
        this.closeFuture = closeFuture;
        return this;
    }

    @Override
    public ContextBuilderImpl withWorkerPool(WorkerPool workerPool) {
        this.workerPool = workerPool;
        return this;
    }

    public ContextBuilderImpl withDeploymentContext(DeploymentContext deploymentContext) {
        this.deploymentContext = deploymentContext;
        return this;
    }

    @Override
    public ContextInternal build() {
        ClassLoader classLoader;
        CloseFuture closeFuture;
        EventLoop eventLoop = this.eventLoop;
        if (eventLoop == null) {
            eventLoop = this.vertx.nettyEventLoopGroup().next();
        }
        if ((closeFuture = this.closeFuture) == null) {
            closeFuture = this.vertx.closeFuture();
        }
        if ((classLoader = this.classLoader) == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        return this.vertx.createContext(this.threadingModel, eventLoop, closeFuture, this.workerPool, this.deploymentContext, classLoader);
    }
}

