/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.file;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.file.FileSystemOptionsConverter;
import io.vertx.core.impl.SysProps;
import io.vertx.core.json.JsonObject;

@DataObject
@JsonGen(publicConverter=false)
public class FileSystemOptions {
    public static final boolean DEFAULT_FILE_CACHING_ENABLED = !SysProps.DISABLE_FILE_CACHING.getBoolean();
    public static final boolean DEFAULT_CLASS_PATH_RESOLVING_ENABLED = !SysProps.DISABLE_FILE_CP_RESOLVING.getBoolean();
    public static final String DEFAULT_FILE_CACHING_DIR = SysProps.FILE_CACHE_DIR.get();
    private boolean classPathResolvingEnabled = DEFAULT_CLASS_PATH_RESOLVING_ENABLED;
    private boolean fileCachingEnabled = DEFAULT_FILE_CACHING_ENABLED;
    private String fileCacheDir = DEFAULT_FILE_CACHING_DIR;

    public FileSystemOptions() {
    }

    public FileSystemOptions(FileSystemOptions other) {
        this.classPathResolvingEnabled = other.isClassPathResolvingEnabled();
        this.fileCachingEnabled = other.isFileCachingEnabled();
        this.fileCacheDir = other.getFileCacheDir();
    }

    public FileSystemOptions(JsonObject json) {
        this();
        FileSystemOptionsConverter.fromJson(json, this);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        FileSystemOptionsConverter.toJson(this, json);
        return json;
    }

    public boolean isClassPathResolvingEnabled() {
        return this.classPathResolvingEnabled;
    }

    public FileSystemOptions setClassPathResolvingEnabled(boolean classPathResolvingEnabled) {
        this.classPathResolvingEnabled = classPathResolvingEnabled;
        return this;
    }

    public boolean isFileCachingEnabled() {
        return this.fileCachingEnabled;
    }

    public FileSystemOptions setFileCachingEnabled(boolean fileCachingEnabled) {
        this.fileCachingEnabled = fileCachingEnabled;
        return this;
    }

    public String getFileCacheDir() {
        return this.fileCacheDir;
    }

    public FileSystemOptions setFileCacheDir(String fileCacheDir) {
        this.fileCacheDir = fileCacheDir;
        return this;
    }

    public String toString() {
        return "FileSystemOptions{classPathResolvingEnabled=" + this.classPathResolvingEnabled + ", fileCachingEnabled=" + this.fileCachingEnabled + ", fileCacheDir=" + this.fileCacheDir + "}";
    }
}

