/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GenericFutureListener;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.impl.buffer.VertxByteBufAllocator;
import io.vertx.core.internal.CloseSequence;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.internal.net.NetClientInternal;
import io.vertx.core.internal.tls.SslContextManager;
import io.vertx.core.internal.tls.SslContextProvider;
import io.vertx.core.net.ClientSSLOptions;
import io.vertx.core.net.ConnectOptions;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.ChannelProvider;
import io.vertx.core.net.impl.NetSocketImpl;
import io.vertx.core.net.impl.ProxyFilter;
import io.vertx.core.net.impl.ShutdownEvent;
import io.vertx.core.net.impl.VertxHandler;
import io.vertx.core.spi.metrics.Metrics;
import io.vertx.core.spi.metrics.TCPMetrics;
import java.io.FileNotFoundException;
import java.net.ConnectException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

class NetClientImpl
implements NetClientInternal {
    private static final Logger log = LoggerFactory.getLogger(NetClientImpl.class);
    protected final int idleTimeout;
    protected final int readIdleTimeout;
    protected final int writeIdleTimeout;
    private final TimeUnit idleTimeoutUnit;
    protected final boolean logEnabled;
    private final VertxInternal vertx;
    private final NetClientOptions options;
    private final SslContextManager sslContextManager;
    private volatile ClientSSLOptions sslOptions;
    public final ChannelGroup channelGroup;
    private final TCPMetrics metrics;
    public ShutdownEvent closeEvent;
    private ChannelGroupFuture graceFuture;
    private final CloseSequence closeSequence;
    private final Predicate<SocketAddress> proxyFilter;

    public NetClientImpl(VertxInternal vertx, TCPMetrics metrics, NetClientOptions options) {
        CloseSequence closeSequence1 = new CloseSequence(this::doClose, this::doGrace, this::doShutdown);
        this.vertx = vertx;
        this.channelGroup = new DefaultChannelGroup((EventExecutor)vertx.getAcceptorEventLoopGroup().next(), true);
        this.options = new NetClientOptions(options);
        this.sslContextManager = new SslContextManager(SslContextManager.resolveEngineOptions(options.getSslEngineOptions(), options.isUseAlpn()));
        this.metrics = metrics;
        this.logEnabled = options.getLogActivity();
        this.idleTimeout = options.getIdleTimeout();
        this.readIdleTimeout = options.getReadIdleTimeout();
        this.writeIdleTimeout = options.getWriteIdleTimeout();
        this.idleTimeoutUnit = options.getIdleTimeoutUnit();
        this.closeSequence = closeSequence1;
        this.proxyFilter = options.getNonProxyHosts() != null ? ProxyFilter.nonProxyHosts(options.getNonProxyHosts()) : ProxyFilter.DEFAULT_PROXY_FILTER;
        this.sslOptions = options.getSslOptions();
    }

    protected void initChannel(ChannelPipeline pipeline, boolean ssl) {
        if (this.logEnabled) {
            pipeline.addLast("logging", (ChannelHandler)new LoggingHandler(this.options.getActivityLogDataFormat()));
        }
        if (ssl || !this.vertx.transport().supportFileRegion()) {
            pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
        }
        if (this.idleTimeout > 0 || this.readIdleTimeout > 0 || this.writeIdleTimeout > 0) {
            pipeline.addLast("idle", (ChannelHandler)new IdleStateHandler((long)this.readIdleTimeout, (long)this.writeIdleTimeout, (long)this.idleTimeout, this.idleTimeoutUnit));
        }
    }

    @Override
    public Future<NetSocket> connect(int port, String host) {
        return this.connect(port, host, null);
    }

    @Override
    public Future<NetSocket> connect(int port, String host, String serverName) {
        return this.connect(SocketAddress.inetSocketAddress(port, host), serverName);
    }

    @Override
    public Future<NetSocket> connect(SocketAddress remoteAddress) {
        return this.connect(remoteAddress, null);
    }

    @Override
    public Future<NetSocket> connect(SocketAddress remoteAddress, String serverName) {
        ConnectOptions connectOptions = new ConnectOptions();
        connectOptions.setRemoteAddress(remoteAddress);
        String peerHost = remoteAddress.host();
        if (peerHost != null && peerHost.endsWith(".")) {
            peerHost = peerHost.substring(0, peerHost.length() - 1);
        }
        if (peerHost != null) {
            connectOptions.setHost(peerHost);
            connectOptions.setPort(remoteAddress.port());
        }
        connectOptions.setSsl(this.options.isSsl());
        connectOptions.setSniServerName(serverName);
        connectOptions.setSslOptions(this.sslOptions);
        return this.connect(connectOptions);
    }

    @Override
    public Future<NetSocket> connect(ConnectOptions connectOptions) {
        ContextInternal context = this.vertx.getOrCreateContext();
        PromiseInternal<NetSocket> promise = context.promise();
        this.connectInternal(connectOptions, this.options.isRegisterWriteHandler(), promise, context, this.options.getReconnectAttempts());
        return promise.future();
    }

    @Override
    public void connectInternal(ConnectOptions connectOptions, Promise<NetSocket> connectHandler, ContextInternal context) {
        ClientSSLOptions sslOptions = connectOptions.getSslOptions();
        if (sslOptions == null) {
            connectOptions.setSslOptions(this.sslOptions);
            if (connectOptions.getSslOptions() == null) {
                connectOptions.setSslOptions(new ClientSSLOptions());
            }
        }
        this.connectInternal(connectOptions, false, connectHandler, context, 0);
    }

    private void doShutdown(Promise<Void> p) {
        if (this.closeEvent == null) {
            this.closeEvent = new ShutdownEvent(0L, TimeUnit.SECONDS);
        }
        this.graceFuture = this.channelGroup.newCloseFuture();
        for (Channel ch : this.channelGroup) {
            ch.pipeline().fireUserEventTriggered((Object)this.closeEvent);
        }
        p.complete();
    }

    private void doGrace(Promise<Void> completion) {
        if (this.closeEvent.timeout() > 0L) {
            long timerID = this.vertx.setTimer(this.closeEvent.timeUnit().toMillis(this.closeEvent.timeout()), v -> completion.complete());
            this.graceFuture.addListener(future -> {
                if (this.vertx.cancelTimer(timerID)) {
                    completion.complete();
                }
            });
        } else {
            completion.complete();
        }
    }

    private void doClose(Promise<Void> completion) {
        ChannelGroupFuture fut = this.channelGroup.close();
        if (this.metrics != null) {
            PromiseInternal p = (PromiseInternal)Promise.promise();
            fut.addListener((GenericFutureListener)p);
            p.future().compose(v -> {
                this.metrics.close();
                return Future.succeededFuture();
            }).onComplete(completion);
        } else {
            fut.addListener((GenericFutureListener)((PromiseInternal)completion));
        }
    }

    @Override
    public void close(Promise<Void> completion) {
        this.closeSequence.close(completion);
    }

    @Override
    public Future<Void> closeFuture() {
        return this.closeSequence.future();
    }

    @Override
    public Future<Void> shutdown(long timeout, TimeUnit timeUnit) {
        this.closeEvent = new ShutdownEvent(timeout, timeUnit);
        return this.closeSequence.close();
    }

    @Override
    public boolean isMetricsEnabled() {
        return this.metrics != null;
    }

    @Override
    public Metrics getMetrics() {
        return this.metrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Boolean> updateSSLOptions(ClientSSLOptions options, boolean force) {
        ContextInternal ctx = this.vertx.getOrCreateContext();
        NetClientImpl netClientImpl = this;
        synchronized (netClientImpl) {
            this.sslOptions = options;
        }
        return ctx.succeededFuture(true);
    }

    private void connectInternal(ConnectOptions connectOptions, boolean registerWriteHandlers, Promise<NetSocket> connectHandler, ContextInternal context, int remainingAttempts) {
        if (this.closeSequence.started()) {
            connectHandler.fail(new IllegalStateException("Client is closed"));
        } else if (connectOptions.isSsl()) {
            ClientSSLOptions sslOptions;
            ClientSSLOptions clientSSLOptions = sslOptions = connectOptions.getSslOptions() != null ? connectOptions.getSslOptions().copy() : this.sslOptions;
            if (sslOptions == null) {
                connectHandler.fail("ClientSSLOptions must be provided when connecting to a TLS server");
                return;
            }
            Future<SslContextProvider> fut = this.sslContextManager.resolveSslContextProvider(sslOptions, sslOptions.getHostnameVerificationAlgorithm(), null, sslOptions.getApplicationLayerProtocols(), context);
            fut.onComplete(ar -> {
                if (ar.succeeded()) {
                    this.connectInternal2(connectOptions, sslOptions, (SslContextProvider)ar.result(), registerWriteHandlers, connectHandler, context, remainingAttempts);
                } else {
                    connectHandler.fail(ar.cause());
                }
            });
        } else {
            this.connectInternal2(connectOptions, connectOptions.getSslOptions(), null, registerWriteHandlers, connectHandler, context, remainingAttempts);
        }
    }

    private void connectInternal2(ConnectOptions connectOptions, ClientSSLOptions sslOptions, SslContextProvider sslContextProvider, boolean registerWriteHandlers, Promise<NetSocket> connectHandler, ContextInternal context, int remainingAttempts) {
        EventLoop eventLoop = context.nettyEventLoop();
        if (eventLoop.inEventLoop()) {
            Objects.requireNonNull(connectHandler, "No null connectHandler accepted");
            Bootstrap bootstrap = new Bootstrap();
            bootstrap.group((EventLoopGroup)eventLoop);
            bootstrap.option(ChannelOption.ALLOCATOR, (Object)VertxByteBufAllocator.POOLED_ALLOCATOR);
            SocketAddress remoteAddress = connectOptions.getRemoteAddress();
            if (remoteAddress == null) {
                String host = connectOptions.getHost();
                Integer port = connectOptions.getPort();
                if (host == null || port == null) {
                    throw new UnsupportedOperationException("handle me");
                }
                remoteAddress = SocketAddress.inetSocketAddress(port, host);
            }
            SocketAddress peerAddress = NetClientImpl.peerAddress(remoteAddress, connectOptions);
            int connectTimeout = connectOptions.getTimeout();
            if (connectTimeout < 0) {
                connectTimeout = this.options.getConnectTimeout();
            }
            this.vertx.transport().configure(this.options, connectTimeout, remoteAddress.isDomainSocket(), bootstrap);
            ProxyOptions proxyOptions = connectOptions.getProxyOptions();
            if (proxyOptions == null) {
                proxyOptions = this.options.getProxyOptions();
            }
            if (this.proxyFilter != null && !this.proxyFilter.test(remoteAddress)) {
                proxyOptions = null;
            }
            ChannelProvider channelProvider = new ChannelProvider(bootstrap, sslContextProvider, context).proxyOptions(proxyOptions);
            SocketAddress captured = remoteAddress;
            channelProvider.handler(ch -> this.connected(context, sslOptions, (Channel)ch, connectHandler, captured, connectOptions.isSsl(), channelProvider.applicationProtocol(), registerWriteHandlers));
            io.netty.util.concurrent.Future<Channel> fut = channelProvider.connect(remoteAddress, peerAddress, connectOptions.getSniServerName(), connectOptions.isSsl(), sslOptions);
            fut.addListener(future -> {
                if (!future.isSuccess()) {
                    boolean connectError;
                    Throwable cause = future.cause();
                    boolean bl = connectError = cause instanceof ConnectException || cause instanceof FileNotFoundException;
                    if (connectError && (remainingAttempts > 0 || remainingAttempts == -1)) {
                        context.emit(v -> {
                            log.debug((Object)("Failed to create connection. Will retry in " + this.options.getReconnectInterval() + " milliseconds"));
                            this.vertx.setTimer(this.options.getReconnectInterval(), tid -> this.connectInternal(connectOptions, registerWriteHandlers, connectHandler, context, remainingAttempts == -1 ? remainingAttempts : remainingAttempts - 1));
                        });
                    } else {
                        this.failed(context, null, cause, connectHandler);
                    }
                }
            });
        } else {
            eventLoop.execute(() -> this.connectInternal2(connectOptions, sslOptions, sslContextProvider, registerWriteHandlers, connectHandler, context, remainingAttempts));
        }
    }

    private static SocketAddress peerAddress(SocketAddress remoteAddress, ConnectOptions connectOptions) {
        if (!connectOptions.isSsl()) {
            return null;
        }
        String peerHost = connectOptions.getHost();
        Integer peerPort = connectOptions.getPort();
        if (remoteAddress.isInetSocket()) {
            if (!(peerHost != null && !peerHost.equals(remoteAddress.host()) || peerPort != null && peerPort.intValue() != remoteAddress.port())) {
                return remoteAddress;
            }
            if (peerHost == null) {
                peerHost = remoteAddress.host();
            }
            if (peerPort == null) {
                peerPort = remoteAddress.port();
            }
        }
        return peerHost != null && peerPort != null ? SocketAddress.inetSocketAddress(peerPort, peerHost) : null;
    }

    private void connected(ContextInternal context, ClientSSLOptions sslOptions, Channel ch, Promise<NetSocket> connectHandler, SocketAddress remoteAddress, boolean ssl, String applicationLayerProtocol, boolean registerWriteHandlers) {
        this.channelGroup.add((Object)ch);
        this.initChannel(ch.pipeline(), ssl);
        VertxHandler<NetSocketImpl> handler = VertxHandler.create(ctx -> new NetSocketImpl(context, (ChannelHandlerContext)ctx, remoteAddress, this.sslContextManager, sslOptions, this.metrics, applicationLayerProtocol, registerWriteHandlers));
        handler.removeHandler(NetSocketImpl::unregisterEventBusHandler);
        handler.addHandler(sock -> {
            if (this.metrics != null) {
                sock.metric(this.metrics.connected(sock.remoteAddress(), sock.remoteName()));
            }
            sock.registerEventBusHandler();
            connectHandler.complete((NetSocket)sock);
        });
        ch.pipeline().addLast("handler", handler);
    }

    private void failed(ContextInternal context, Channel ch, Throwable th, Promise<NetSocket> connectHandler) {
        if (ch != null) {
            ch.close();
        }
        context.emit(th, connectHandler::tryFail);
    }
}

