/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.ServerWebSocketHandshake;
import io.vertx.core.http.impl.HttpServerConnectionHandler;
import io.vertx.core.http.impl.HttpServerConnectionInitializer;
import io.vertx.core.impl.SysProps;
import io.vertx.core.internal.CloseSequence;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.ServerSSLOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.TrafficShapingOptions;
import io.vertx.core.net.impl.NetServerImpl;
import io.vertx.core.net.impl.NetServerInternal;
import io.vertx.core.net.impl.NetSocketImpl;
import io.vertx.core.spi.metrics.Metrics;
import io.vertx.core.spi.metrics.MetricsProvider;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class HttpServerImpl
implements HttpServer,
MetricsProvider {
    static final Logger log = LoggerFactory.getLogger(HttpServerImpl.class);
    private static final Handler<Throwable> DEFAULT_EXCEPTION_HANDLER = t -> log.trace((Object)"Connection failure", t);
    static final boolean DISABLE_WEBSOCKETS = SysProps.DISABLE_WEBSOCKETS.getBoolean();
    private final VertxInternal vertx;
    final HttpServerOptions options;
    private Handler<HttpServerRequest> requestHandler;
    private Handler<ServerWebSocket> webSocketHandler;
    private Handler<ServerWebSocketHandshake> webSocketHandhakeHandler;
    private Handler<HttpServerRequest> invalidRequestHandler;
    private Handler<HttpConnection> connectionHandler;
    private Handler<Throwable> exceptionHandler;
    private NetServerInternal tcpServer;
    private long closeTimeout = 0L;
    private TimeUnit closeTimeoutUnit = TimeUnit.SECONDS;
    private CloseSequence closeSequence;

    public HttpServerImpl(VertxInternal vertx, HttpServerOptions options) {
        this.vertx = vertx;
        this.options = options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Boolean> updateSSLOptions(ServerSSLOptions options, boolean force) {
        NetServerInternal s;
        HttpServerImpl httpServerImpl = this;
        synchronized (httpServerImpl) {
            s = this.tcpServer;
        }
        if (s == null) {
            throw new IllegalStateException("Not listening");
        }
        options = options.copy();
        this.configureApplicationLayerProtocols(options);
        return s.updateSSLOptions(options, force);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Boolean> updateTrafficShapingOptions(TrafficShapingOptions options) {
        NetServerInternal s;
        HttpServerImpl httpServerImpl = this;
        synchronized (httpServerImpl) {
            s = this.tcpServer;
        }
        if (s == null) {
            throw new IllegalStateException("Not listening");
        }
        return s.updateTrafficShapingOptions(options);
    }

    @Override
    public synchronized int actualPort() {
        NetServerInternal s = this.tcpServer;
        return s != null ? s.actualPort() : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Metrics getMetrics() {
        NetServerImpl s;
        HttpServerImpl httpServerImpl = this;
        synchronized (httpServerImpl) {
            s = (NetServerImpl)this.tcpServer;
        }
        return s == null ? null : s.getMetrics();
    }

    @Override
    public synchronized HttpServer requestHandler(Handler<HttpServerRequest> handler) {
        if (this.isListening()) {
            throw new IllegalStateException("Please set handler before server is listening");
        }
        this.requestHandler = handler;
        return this;
    }

    @Override
    public synchronized HttpServer webSocketHandler(Handler<ServerWebSocket> handler) {
        if (this.isListening()) {
            throw new IllegalStateException("Please set handler before server is listening");
        }
        this.webSocketHandler = handler;
        return this;
    }

    @Override
    public HttpServer webSocketHandshakeHandler(Handler<ServerWebSocketHandshake> handler) {
        if (this.isListening()) {
            throw new IllegalStateException("Please set handler before server is listening");
        }
        this.webSocketHandhakeHandler = handler;
        return this;
    }

    @Override
    public synchronized Handler<HttpServerRequest> requestHandler() {
        return this.requestHandler;
    }

    @Override
    public synchronized HttpServer invalidRequestHandler(Handler<HttpServerRequest> handler) {
        if (this.isListening()) {
            throw new IllegalStateException("Please set handler before server is listening");
        }
        this.invalidRequestHandler = handler;
        return this;
    }

    @Override
    public synchronized HttpServer connectionHandler(Handler<HttpConnection> handler) {
        if (this.isListening()) {
            throw new IllegalStateException("Please set handler before server is listening");
        }
        this.connectionHandler = handler;
        return this;
    }

    @Override
    public synchronized HttpServer exceptionHandler(Handler<Throwable> handler) {
        if (this.isListening()) {
            throw new IllegalStateException("Please set handler before server is listening");
        }
        this.exceptionHandler = handler;
        return this;
    }

    @Override
    public synchronized Handler<ServerWebSocket> webSocketHandler() {
        return this.webSocketHandler;
    }

    @Override
    public Future<HttpServer> listen() {
        return this.listen(this.options.getPort(), this.options.getHost());
    }

    @Override
    public synchronized Future<HttpServer> listen(SocketAddress address) {
        ContextInternal context;
        if (this.requestHandler == null && this.webSocketHandler == null && this.webSocketHandhakeHandler == null) {
            throw new IllegalStateException("Set request or WebSocket handler first");
        }
        if (this.tcpServer != null) {
            throw new IllegalStateException();
        }
        HttpServerOptions options = this.options;
        HttpServerOptions tcpOptions = new HttpServerOptions(options);
        if (tcpOptions.getSslOptions() != null) {
            this.configureApplicationLayerProtocols(tcpOptions.getSslOptions());
        }
        ContextInternal listenContext = (context = this.vertx.getOrCreateContext()).isEventLoopContext() ? context : this.vertx.createEventLoopContext(context.nettyEventLoop(), context.workerPool(), context.classLoader());
        NetServerInternal server = this.vertx.createNetServer(tcpOptions);
        Handler<Throwable> h = this.exceptionHandler;
        Handler<Throwable> exceptionHandler = h != null ? h : DEFAULT_EXCEPTION_HANDLER;
        server.exceptionHandler((Handler)exceptionHandler);
        server.connectHandler(so -> {
            NetSocketImpl soi = (NetSocketImpl)so;
            Supplier<ContextInternal> streamContextSupplier = context::duplicate;
            String host = address.isInetSocket() ? address.host() : "localhost";
            int port = address.port();
            String serverOrigin = (tcpOptions.isSsl() ? "https" : "http") + "://" + host + ":" + port;
            HttpServerConnectionHandler handler = new HttpServerConnectionHandler(this, this.requestHandler, this.invalidRequestHandler, this.webSocketHandler, this.webSocketHandhakeHandler, this.connectionHandler, exceptionHandler);
            HttpServerConnectionInitializer initializer = new HttpServerConnectionInitializer(listenContext, streamContextSupplier, this, this.vertx, options, serverOrigin, handler, exceptionHandler, soi.metric());
            initializer.configurePipeline(soi.channel(), null, null);
        });
        this.tcpServer = server;
        this.closeSequence = new CloseSequence(p -> this.doClose(server, p), p -> this.doShutdown(server, p));
        PromiseInternal result = context.promise();
        this.tcpServer.listen(listenContext, address).onComplete(ar -> {
            if (ar.succeeded()) {
                result.complete(this);
            } else {
                result.fail(ar.cause());
            }
        });
        return result.future();
    }

    private void doShutdown(NetServer netServer, Promise<Void> p) {
        netServer.shutdown(this.closeTimeout, this.closeTimeoutUnit).onComplete(p);
    }

    private void doClose(NetServer netServer, Promise<Void> p) {
        netServer.close().onComplete(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> shutdown(long timeout, TimeUnit unit) {
        CloseSequence seq;
        HttpServerImpl httpServerImpl = this;
        synchronized (httpServerImpl) {
            seq = this.closeSequence;
            this.closeTimeout = timeout;
            this.closeTimeoutUnit = unit;
            this.closeSequence = null;
        }
        ContextInternal ctx = this.vertx.getOrCreateContext();
        if (seq == null) {
            return ctx.succeededFuture();
        }
        PromiseInternal p = ctx.promise();
        seq.close().onComplete(p);
        return p.future();
    }

    private void configureApplicationLayerProtocols(ServerSSLOptions options) {
        List applicationProtocols = this.options.getAlpnVersions().stream().map(HttpVersion::alpnName).collect(Collectors.toList());
        options.setApplicationLayerProtocols(applicationProtocols);
    }

    private boolean isListening() {
        return this.tcpServer != null;
    }

    public synchronized boolean isClosed() {
        NetServerImpl s = (NetServerImpl)this.tcpServer;
        return s == null || s.isClosed();
    }

    boolean requestAccept() {
        return true;
    }

    boolean wsAccept() {
        return true;
    }
}

