/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.handler.codec.http2.Http2Error;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpClosedException;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.StreamResetException;
import io.vertx.core.http.impl.HttpClientPush;
import io.vertx.core.http.impl.HttpClientRequestPushPromise;
import io.vertx.core.http.impl.HttpClientResponseImpl;
import io.vertx.core.http.impl.HttpClientStream;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.impl.NoStackTraceTimeoutException;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.net.HostAndPort;
import java.util.Objects;

public abstract class HttpClientRequestBase
implements HttpClientRequest {
    protected final ContextInternal context;
    protected final HttpClientStream stream;
    protected final boolean ssl;
    private HttpMethod method;
    private HostAndPort authority;
    private String uri;
    private String path;
    private String query;
    private final PromiseInternal<HttpClientResponse> responsePromise;
    private Handler<HttpClientRequest> pushHandler;
    private long currentTimeoutTimerId = -1L;
    private long currentTimeoutMs;
    private long lastDataReceived;
    private Throwable reset;
    private HttpConnection connection;

    HttpClientRequestBase(HttpConnection connection, HttpClientStream stream, PromiseInternal<HttpClientResponse> responsePromise, HttpMethod method, String uri) {
        this.connection = connection;
        this.stream = stream;
        this.responsePromise = responsePromise;
        this.context = responsePromise.context();
        this.uri = uri;
        this.method = method;
        this.authority = stream.connection().authority();
        this.ssl = stream.connection().isSsl();
        stream.pushHandler(this::handlePush);
        stream.headHandler(resp -> {
            HttpClientResponseImpl response = new HttpClientResponseImpl(this, stream.version(), stream, resp.statusCode, resp.statusMessage, resp.headers);
            stream.chunkHandler(response::handleChunk);
            stream.endHandler(response::handleEnd);
            stream.priorityHandler(response::handlePriorityChange);
            stream.unknownFrameHandler(response::handleUnknownFrame);
            this.handleResponse(response);
        });
    }

    protected String authority() {
        if (this.authority == null) {
            return null;
        }
        if (this.authority.port() == 80 && !this.ssl || this.authority.port() == 443 && this.ssl || this.authority.port() < 0) {
            return this.authority.host();
        }
        return this.authority.host() + ":" + this.authority.port();
    }

    @Override
    public int streamId() {
        return this.stream.id();
    }

    @Override
    public String absoluteURI() {
        return (this.ssl ? "https://" : "http://") + this.authority() + this.uri;
    }

    @Override
    public String query() {
        if (this.query == null) {
            this.query = HttpUtils.parseQuery(this.uri);
        }
        return this.query;
    }

    @Override
    public String path() {
        if (this.path == null) {
            this.path = HttpUtils.parsePath(this.uri);
        }
        return this.path;
    }

    @Override
    public synchronized String getURI() {
        return this.uri;
    }

    @Override
    public HttpConnection connection() {
        return this.connection;
    }

    @Override
    public synchronized HttpClientRequest setURI(String uri) {
        Objects.requireNonNull(uri);
        this.uri = uri;
        this.path = null;
        this.query = null;
        return this;
    }

    @Override
    public synchronized HttpClientRequest authority(HostAndPort authority) {
        Objects.requireNonNull(authority);
        this.authority = authority;
        return this;
    }

    @Override
    public synchronized HttpMethod getMethod() {
        return this.method;
    }

    @Override
    public synchronized HttpClientRequest setMethod(HttpMethod method) {
        Objects.requireNonNull(this.uri);
        this.method = method;
        return this;
    }

    @Override
    public synchronized HttpClientRequest idleTimeout(long timeout) {
        this.cancelTimeout();
        this.currentTimeoutMs = timeout;
        this.currentTimeoutTimerId = this.context.setTimer(timeout, id -> this.handleTimeout(timeout));
        return this;
    }

    protected Throwable mapException(Throwable t) {
        if (t instanceof HttpClosedException && this.reset != null) {
            t = this.reset;
        }
        return t;
    }

    void handleException(Throwable t) {
        this.fail(t);
    }

    void fail(Throwable t) {
        this.cancelTimeout();
        this.responsePromise.tryFail(t);
        HttpClientResponseImpl response = (HttpClientResponseImpl)this.responsePromise.future().result();
        if (response != null) {
            response.handleException(t);
        }
    }

    void handlePush(HttpClientPush push) {
        HttpClientRequestPushPromise pushReq = new HttpClientRequestPushPromise(this.connection, push.stream, push.method, push.uri, push.headers);
        if (this.pushHandler != null) {
            this.pushHandler.handle(pushReq);
        } else {
            pushReq.reset(Http2Error.CANCEL.code());
        }
    }

    void handleResponse(HttpClientResponse resp) {
        if (this.reset == null) {
            this.handleResponse(this.responsePromise, resp, this.cancelTimeout());
        }
    }

    abstract void handleResponse(Promise<HttpClientResponse> var1, HttpClientResponse var2, long var3);

    private synchronized long cancelTimeout() {
        long ret = this.currentTimeoutTimerId;
        if (ret != -1L) {
            this.context.owner().cancelTimer(this.currentTimeoutTimerId);
            this.currentTimeoutTimerId = -1L;
            ret = this.currentTimeoutMs;
            this.currentTimeoutMs = 0L;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTimeout(long timeoutMs) {
        NoStackTraceTimeoutException cause;
        HttpClientRequestBase httpClientRequestBase = this;
        synchronized (httpClientRequestBase) {
            long now;
            long timeSinceLastData;
            this.currentTimeoutTimerId = -1L;
            this.currentTimeoutMs = 0L;
            if (this.lastDataReceived > 0L && (timeSinceLastData = (now = System.currentTimeMillis()) - this.lastDataReceived) < timeoutMs) {
                this.lastDataReceived = 0L;
                this.idleTimeout(timeoutMs - timeSinceLastData);
                return;
            }
            cause = HttpClientRequestBase.timeoutEx(timeoutMs, this.method, this.authority, this.uri);
        }
        this.reset(cause);
    }

    static NoStackTraceTimeoutException timeoutEx(long timeoutMs, HttpMethod method, HostAndPort peer, String uri) {
        return new NoStackTraceTimeoutException("The timeout period of " + timeoutMs + "ms has been exceeded while executing " + method + " " + uri + " for server " + peer);
    }

    synchronized void dataReceived() {
        if (this.currentTimeoutTimerId != -1L) {
            this.lastDataReceived = System.currentTimeMillis();
        }
    }

    @Override
    public Future<Void> reset(long code) {
        return this.reset(new StreamResetException(code));
    }

    @Override
    public Future<Void> reset(long code, Throwable cause) {
        return this.reset(new StreamResetException(code, cause));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<Void> reset(Throwable cause) {
        HttpClientRequestBase httpClientRequestBase = this;
        synchronized (httpClientRequestBase) {
            if (this.reset != null) {
                return this.context.failedFuture("Already reset");
            }
            this.reset = cause;
        }
        return this.stream.reset(cause);
    }

    @Override
    public Future<HttpClientResponse> response() {
        return this.responsePromise.future();
    }

    synchronized Handler<HttpClientRequest> pushHandler() {
        return this.pushHandler;
    }

    @Override
    public synchronized HttpClientRequest pushHandler(Handler<HttpClientRequest> handler) {
        this.pushHandler = handler;
        return this;
    }
}

