/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.streams.impl;

import io.netty.util.internal.PlatformDependent;
import io.vertx.core.impl.Arguments;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.Predicate;

public class OutboundWriteQueue<E> {
    public static final int QUEUE_UNWRITABLE_MASK = 1;
    public static final int QUEUE_WRITABLE_MASK = 2;
    public static final int DRAIN_REQUIRED_MASK = 4;
    public static final int DEFAULT_HIGH_WATER_MARK = 16;
    public static final int DEFAULT_LOW_WATER_MARK = 8;
    private static final AtomicLongFieldUpdater<OutboundWriteQueue<?>> WIP_UPDATER = AtomicLongFieldUpdater.newUpdater(OutboundWriteQueue.class, "wip");
    private final Predicate<E> consumer;
    private final long highWaterMark;
    private final long lowWaterMark;
    private final Queue<E> queue = PlatformDependent.newMpscQueue();
    private volatile long wip = 0L;
    private E overflow;
    private long writeQueueFull;

    public static int numberOfUnwritableSignals(int value) {
        return (value & 0xFFFFFFF0) >> 4;
    }

    public OutboundWriteQueue(Predicate<E> consumer) {
        this(consumer, 8L, 16L);
    }

    public OutboundWriteQueue(Predicate<E> consumer, long lowWaterMark, long highWaterMark) {
        Arguments.require(lowWaterMark >= 0L, "The low-water mark must be >= 0");
        Arguments.require(lowWaterMark <= highWaterMark, "The high-water mark must greater or equals to the low-water mark");
        this.consumer = Objects.requireNonNull(consumer, "Consumer must be not null");
        this.lowWaterMark = lowWaterMark;
        this.highWaterMark = highWaterMark;
    }

    public long highWaterMark() {
        return this.highWaterMark;
    }

    public long lowWaterMark() {
        return this.lowWaterMark;
    }

    public int add(E element) {
        if (WIP_UPDATER.compareAndSet(this, 0L, 1L)) {
            if (!this.consumer.test(element)) {
                this.overflow = element;
                return 4;
            }
            if (this.consume(1) == 0L) {
                return 0;
            }
            return this.drainLoop();
        }
        this.queue.add(element);
        long v = WIP_UPDATER.incrementAndGet(this);
        if (v == 1L) {
            return this.drainLoop();
        }
        return v == this.highWaterMark ? 1 : 0;
    }

    public int submit(E element) {
        this.queue.add(element);
        long pending = WIP_UPDATER.incrementAndGet(this);
        if (pending == this.highWaterMark) {
            this.hook2();
        }
        return (pending == this.highWaterMark ? 1 : 0) + (pending == 1L ? 4 : 0);
    }

    protected void hook2() {
    }

    public int drain() {
        E elt = this.overflow;
        if (elt != null) {
            if (!this.consumer.test(this.overflow)) {
                return 4;
            }
            this.overflow = null;
            if (this.consume(1) == 0L) {
                return 0;
            }
        }
        this.hook();
        return this.drainLoop();
    }

    private int drainLoop() {
        int consumed;
        long pending = WIP_UPDATER.get(this);
        if (pending == 0L) {
            throw new IllegalStateException();
        }
        block0: do {
            consumed = 0;
            while ((long)consumed < pending) {
                E elt = this.queue.poll();
                if (!this.consumer.test(elt)) {
                    this.overflow = elt;
                    continue block0;
                }
                ++consumed;
            }
        } while ((pending = this.consume(consumed)) != 0L && this.overflow == null);
        boolean writabilityChanged = pending < this.lowWaterMark && this.writeQueueFull > 0L;
        long val = this.writeQueueFull << 4;
        if (writabilityChanged) {
            this.writeQueueFull = 0L;
        }
        int flags = 0;
        flags |= this.overflow != null ? 4 : 0;
        flags |= writabilityChanged ? 2 : 0;
        flags = (int)((long)flags | val);
        return flags;
    }

    private long consume(int amount) {
        long pending = WIP_UPDATER.addAndGet(this, -amount);
        long size = pending + (long)amount;
        if (size >= this.highWaterMark && size - (long)amount < this.highWaterMark) {
            ++this.writeQueueFull;
        }
        return pending;
    }

    protected void hook() {
    }

    public final List<E> clear() {
        this.writeQueueFull = 0L;
        ArrayList<E> elts = new ArrayList<E>();
        if (this.overflow != null) {
            elts.add(this.overflow);
            this.overflow = null;
            if (WIP_UPDATER.decrementAndGet(this) == 0L) {
                return elts;
            }
        }
        long pending = WIP_UPDATER.get(this);
        while (pending != 0L) {
            int i = 0;
            while ((long)i < pending) {
                elts.add(this.queue.poll());
                ++i;
            }
            pending = WIP_UPDATER.addAndGet(this, -pending);
        }
        return elts;
    }
}

