/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.spi.cluster.impl;

import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.core.spi.cluster.RegistrationUpdateEvent;
import io.vertx.core.spi.cluster.impl.NodeSelector;
import io.vertx.core.spi.cluster.impl.selector.Selectors;

public class DefaultNodeSelector
implements NodeSelector {
    private Selectors selectors;

    @Override
    public void init(Vertx vertx, ClusterManager clusterManager) {
        this.selectors = new Selectors(clusterManager);
    }

    @Override
    public void eventBusStarted() {
    }

    @Override
    public void selectForSend(String address, Promise<String> promise) {
        this.selectors.withSelector(address, promise, (prom, selector) -> prom.tryComplete(selector.selectForSend()));
    }

    @Override
    public void selectForPublish(String address, Promise<Iterable<String>> promise) {
        this.selectors.withSelector(address, promise, (prom, selector) -> prom.tryComplete(selector.selectForPublish()));
    }

    @Override
    public void registrationsUpdated(RegistrationUpdateEvent event) {
        this.selectors.dataReceived(event.address(), event.registrations(), true);
    }

    @Override
    public void registrationsLost() {
        this.selectors.dataLost();
    }

    @Override
    public boolean wantsUpdatesFor(String address) {
        return this.selectors.hasEntryFor(address);
    }
}

