/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultFileRegion;
import io.netty.channel.EventLoop;
import io.netty.channel.VoidChannelPromise;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.handler.stream.ChunkedNioFile;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ScheduledFuture;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.concurrent.OutboundMessageQueue;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.core.net.impl.MessageWrite;
import io.vertx.core.net.impl.ShutdownEvent;
import io.vertx.core.spi.metrics.Metrics;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class VertxConnection
extends ConnectionBase {
    private static final Logger log = LoggerFactory.getLogger(VertxConnection.class);
    private static final int MAX_REGION_SIZE = 0x100000;
    public final VoidChannelPromise voidPromise;
    private final OutboundMessageQueue<MessageWrite> messageQueue;
    private Handler<Void> shutdownHandler;
    private boolean read;
    private boolean needsFlush;
    private boolean draining;
    private boolean channelWritable;
    private boolean paused;
    private Deque<Object> pending;
    private boolean autoRead;
    private ScheduledFuture<?> shutdownTimeout;

    public VertxConnection(ContextInternal context, ChannelHandlerContext chctx) {
        super(context, chctx);
        this.channelWritable = chctx.channel().isWritable();
        this.messageQueue = new InternalMessageQueue(chctx.channel().eventLoop());
        this.voidPromise = new VoidChannelPromise(chctx.channel(), false);
    }

    public synchronized ConnectionBase shutdownHandler(@Nullable Handler<Void> handler) {
        this.shutdownHandler = handler;
        return this;
    }

    public final Future<Void> shutdown(long timeout, TimeUnit unit) {
        return this.shutdown(null, timeout, unit);
    }

    public final Future<Void> shutdown(Object reason, long timeout, TimeUnit unit) {
        PromiseInternal<Void> promise = this.vertx.promise();
        EventExecutor eventLoop = this.chctx.executor();
        if (eventLoop.inEventLoop()) {
            this.shutdown(reason, timeout, unit, promise);
        } else {
            eventLoop.execute(() -> this.shutdown(reason, timeout, unit, promise));
        }
        return promise.future();
    }

    private void shutdown(Object reason, long timeout, TimeUnit unit, Promise<Void> promise) {
        this.close(reason, timeout, unit).onComplete(promise);
    }

    protected void handleEvent(Object event) {
        if (event instanceof ShutdownEvent) {
            ShutdownEvent shutdown = (ShutdownEvent)event;
            this.shutdown(shutdown.timeout(), shutdown.timeUnit());
        } else {
            ReferenceCountUtil.release((Object)event);
        }
    }

    protected void handleIdle(IdleStateEvent event) {
        log.debug((Object)"The connection will be closed due to timeout");
        this.chctx.close();
    }

    protected boolean supportsFileRegion() {
        return this.vertx.transport().supportFileRegion() && !this.isSsl() && !this.isTrafficShaped();
    }

    protected void handleShutdown(Object reason, long timeout, TimeUnit unit, ChannelPromise promise) {
        ScheduledFuture<?> t = this.shutdownTimeout;
        if (t != null) {
            this.shutdownTimeout = null;
            t.cancel(false);
            super.handleClose(reason, 0L, TimeUnit.SECONDS, promise);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final void handleClose(Object reason, long timeout, TimeUnit unit, ChannelPromise promise) {
        if (timeout == 0L) {
            super.handleClose(reason, timeout, unit, promise);
        } else {
            Handler<Void> handler;
            EventExecutor el = this.chctx.executor();
            this.shutdownTimeout = el.schedule(() -> {
                this.shutdownTimeout = null;
                super.handleClose(reason, 0L, TimeUnit.SECONDS, promise);
            }, timeout, unit);
            VertxConnection vertxConnection = this;
            synchronized (vertxConnection) {
                handler = this.shutdownHandler;
            }
            if (handler != null) {
                this.context.emit(handler);
            }
            this.handleShutdown(reason, timeout, unit, promise);
        }
    }

    @Override
    protected void handleClose(Object reason, ChannelPromise promise) {
        this.writeClose(promise);
    }

    @Override
    protected void handleClosed() {
        ScheduledFuture<?> timeout = this.shutdownTimeout;
        if (timeout != null) {
            this.shutdownTimeout = null;
            timeout.cancel(false);
        }
        this.messageQueue.close();
        super.handleClosed();
    }

    protected void handleWriteQueueDrained() {
    }

    protected void handleMessage(Object msg) {
    }

    void channelWritabilityChanged() {
        this.channelWritable = this.chctx.channel().isWritable();
        if (this.channelWritable) {
            this.messageQueue.drain();
        }
    }

    final void endReadAndFlush() {
        if (this.read) {
            this.read = false;
            if (this.needsFlush) {
                this.needsFlush = false;
                this.chctx.flush();
            }
        }
    }

    final void read(Object msg) {
        this.read = true;
        if (Metrics.METRICS_ENABLED) {
            this.reportBytesRead(msg);
        }
        if (this.paused) {
            this.addPending(msg);
            return;
        }
        this.handleMessage(msg);
    }

    private void addPending(Object msg) {
        if (this.pending == null) {
            this.pending = new ArrayDeque<Object>();
        }
        this.pending.add(msg);
        if (this.pending.size() >= 8) {
            this.autoRead = false;
            this.chctx.channel().config().setAutoRead(false);
        }
    }

    public void write(Object msg, boolean forceFlush, FutureListener<Void> promise) {
        this.write(msg, forceFlush, this.wrap(promise));
    }

    public void write(Object msg, boolean forceFlush, ChannelPromise promise) {
        assert (this.chctx.executor().inEventLoop());
        if (Metrics.METRICS_ENABLED) {
            this.reportsBytesWritten(msg);
        }
        boolean flush = !this.read && !this.draining || forceFlush;
        boolean bl = this.needsFlush = !flush;
        if (flush) {
            this.chctx.writeAndFlush(msg, promise);
        } else {
            this.chctx.write(msg, promise);
        }
    }

    private void writeClose(ChannelPromise promise) {
        ChannelPromise channelPromise = this.chctx.newPromise().addListener((GenericFutureListener)((ChannelFutureListener)f -> this.chctx.close(promise)));
        this.writeToChannel(Unpooled.EMPTY_BUFFER, true, channelPromise);
    }

    public final boolean writeToChannel(Object obj) {
        return this.writeToChannel(obj, (ChannelPromise)this.voidPromise);
    }

    public final boolean writeToChannel(Object msg, FutureListener<Void> listener) {
        return this.writeToChannel(msg, (ChannelPromise)(listener == null ? this.voidPromise : this.wrap(listener)));
    }

    public final boolean writeToChannel(Object msg, ChannelPromise promise) {
        return this.writeToChannel(msg, false, promise);
    }

    public final boolean writeToChannel(final Object msg, final boolean forceFlush, final ChannelPromise promise) {
        return this.writeToChannel(new MessageWrite(){

            @Override
            public void write() {
                VertxConnection.this.write(msg, forceFlush, promise);
            }

            @Override
            public void cancel(Throwable cause) {
                promise.setFailure(cause);
            }
        });
    }

    public final boolean writeToChannel(MessageWrite msg) {
        return this.messageQueue.write(msg);
    }

    public final void flush() {
        this.flush((ChannelPromise)this.voidPromise);
    }

    public final void flush(ChannelPromise promise) {
        this.writeToChannel(Unpooled.EMPTY_BUFFER, true, promise);
    }

    public final void flush(FutureListener<Void> listener) {
        this.writeToChannel(Unpooled.EMPTY_BUFFER, true, (ChannelPromise)(listener == null ? this.voidPromise : this.wrap(listener)));
    }

    public boolean writeQueueFull() {
        return !this.messageQueue.isWritable();
    }

    private void sendFileRegion(RandomAccessFile file, long offset, long length, ChannelPromise writeFuture) {
        if (length < 0x100000L) {
            this.writeToChannel((Object)new DefaultFileRegion(file.getChannel(), offset, length), writeFuture);
        } else {
            ChannelPromise promise = this.chctx.newPromise();
            DefaultFileRegion region = new DefaultFileRegion(file.getChannel(), offset, 0x100000L);
            region.retain();
            this.writeToChannel((Object)region, promise);
            promise.addListener(future -> {
                if (future.isSuccess()) {
                    this.sendFileRegion(file, offset + 0x100000L, length - 0x100000L, writeFuture);
                } else {
                    log.error((Object)future.cause().getMessage(), future.cause());
                    writeFuture.setFailure(future.cause());
                }
            });
        }
    }

    public ChannelFuture sendFile(RandomAccessFile raf, long offset, long length) {
        ChannelPromise writeFuture = this.chctx.newPromise();
        if (!this.supportsFileRegion()) {
            try {
                this.writeToChannel((Object)new ChunkedNioFile(raf.getChannel(), offset, length, 8192), writeFuture);
            }
            catch (IOException e) {
                return this.chctx.newFailedFuture((Throwable)e);
            }
        } else {
            this.sendFileRegion(raf, offset, length, writeFuture);
        }
        writeFuture.addListener(fut -> raf.close());
        return writeFuture;
    }

    public final void doPause() {
        assert (this.chctx.executor().inEventLoop());
        this.paused = true;
    }

    public final void doResume() {
        assert (this.chctx.executor().inEventLoop());
        if (!this.paused) {
            return;
        }
        this.paused = false;
        if (this.pending != null && !this.pending.isEmpty()) {
            boolean end = !this.read;
            this.read = true;
            try {
                Object msg;
                while (!this.paused && (msg = this.pending.poll()) != null) {
                    this.handleMessage(msg);
                }
            }
            finally {
                if (end) {
                    this.endReadAndFlush();
                }
                if (this.pending.isEmpty() && !this.autoRead) {
                    this.autoRead = true;
                    this.chctx.channel().config().setAutoRead(true);
                }
            }
        }
    }

    public void doSetWriteQueueMaxSize(int size) {
        ChannelConfig config = this.chctx.channel().config();
        config.setWriteBufferWaterMark(new WriteBufferWaterMark(size / 2, size));
    }

    private class InternalMessageQueue
    extends OutboundMessageQueue<MessageWrite>
    implements Predicate<MessageWrite> {
        public InternalMessageQueue(EventLoop eventLoop) {
            super(eventLoop);
        }

        @Override
        public boolean test(MessageWrite msg) {
            if (VertxConnection.this.channelWritable) {
                msg.write();
                return true;
            }
            return false;
        }

        @Override
        protected void disposeMessage(MessageWrite write) {
            write.cancel(ConnectionBase.CLOSED_EXCEPTION);
        }

        @Override
        protected void startDraining() {
            VertxConnection.this.draining = true;
        }

        @Override
        protected void stopDraining() {
            VertxConnection.this.draining = false;
            if (!VertxConnection.this.read && VertxConnection.this.needsFlush) {
                VertxConnection.this.needsFlush = false;
                VertxConnection.this.chctx.flush();
            }
        }

        @Override
        protected void writeQueueDrained() {
            VertxConnection.this.handleWriteQueueDrained();
        }
    }
}

