/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.vertx.core.net.HostAndPort;
import java.util.Arrays;

public class HostAndPortImpl
implements HostAndPort {
    private static final byte[] DIGITS = new byte[128];
    private final String host;
    private final int port;

    public static int parseHost(String val, int from, int to) {
        int pos = HostAndPortImpl.parseIPLiteral(val, from, to);
        if (pos != -1) {
            return pos;
        }
        pos = HostAndPortImpl.parseIPv4Address(val, from, to);
        if (pos != -1) {
            return pos;
        }
        pos = HostAndPortImpl.parseRegName(val, from, to);
        if (pos != -1) {
            return pos;
        }
        return -1;
    }

    private static int foo(int v) {
        return v == -1 ? -1 : v + 1;
    }

    public static int parseIPv4Address(String s, int from, int to) {
        for (int i = 0; i < 4; ++i) {
            if (i > 0 && from < to && s.charAt(from++) != '.') {
                return -1;
            }
            if ((from = HostAndPortImpl.parseDecOctet(s, from, to)) != -1) continue;
            return -1;
        }
        if (from == to) {
            return from;
        }
        assert (from < to);
        if (from + 1 == s.length()) {
            return -1;
        }
        if (s.charAt(from) != ':') {
            return -1;
        }
        return from;
    }

    public static int parseDecOctet(String s, int from, int to) {
        int val;
        if ((val = HostAndPortImpl.parseDigit(s, from++, to)) == 0) {
            return from;
        }
        if (val < 0 || val > 9) {
            return -1;
        }
        int n = HostAndPortImpl.parseDigit(s, from, to);
        if (n != -1) {
            val = val * 10 + n;
            if ((n = HostAndPortImpl.parseDigit(s, ++from, to)) != -1) {
                ++from;
                val = val * 10 + n;
            }
        }
        if (val < 256) {
            return from;
        }
        return -1;
    }

    private static int parseDigit(String s, int from, int to) {
        if (from >= to) {
            return -1;
        }
        char ch = s.charAt(from);
        if (ch < '\u0080') {
            return DIGITS[ch];
        }
        return -1;
    }

    public static int parseIPLiteral(String s, int from, int to) {
        return from + 2 < to && s.charAt(from) == '[' ? HostAndPortImpl.foo(s.indexOf(93, from + 2)) : -1;
    }

    public static int parseRegName(String s, int from, int to) {
        while (from < to) {
            char c = s.charAt(from);
            if (HostAndPortImpl.isUnreserved(c) || HostAndPortImpl.isSubDelims(c)) {
                ++from;
                continue;
            }
            if (c != '%' || from + 2 >= to || !HostAndPortImpl.isHEXDIG(s.charAt(c + '\u0001')) || !HostAndPortImpl.isHEXDIG(s.charAt(c + 2))) break;
            from += 3;
        }
        return from;
    }

    private static boolean isUnreserved(char ch) {
        return HostAndPortImpl.isALPHA(ch) || HostAndPortImpl.isDIGIT(ch) || ch == '-' || ch == '.' || ch == '_' || ch == '~';
    }

    private static boolean isALPHA(char ch) {
        return 'A' <= ch && ch <= 'Z' || 'a' <= ch && ch <= 'z';
    }

    private static boolean isDIGIT(char ch) {
        return DIGITS[ch] != -1;
    }

    private static boolean isSubDelims(char ch) {
        return ch == '!' || ch == '$' || ch == '&' || ch == '\'' || ch == '(' || ch == ')' || ch == '*' || ch == '+' || ch == ',' || ch == ';' || ch == '=';
    }

    static boolean isHEXDIG(char ch) {
        return HostAndPortImpl.isDIGIT(ch) || 'A' <= ch && ch <= 'F' || 'a' <= ch && ch <= 'f';
    }

    public static boolean isValidAuthority(String s) {
        int pos = HostAndPortImpl.parseHost(s, 0, s.length());
        if (pos == s.length()) {
            return true;
        }
        if (pos < s.length() && s.charAt(pos) == ':') {
            return HostAndPortImpl.parsePort(s, pos) != -1;
        }
        return false;
    }

    public static HostAndPortImpl parseAuthority(String s, int schemePort) {
        int pos = HostAndPortImpl.parseHost(s, 0, s.length());
        if (pos == s.length()) {
            return new HostAndPortImpl(s, schemePort);
        }
        if (pos < s.length() && s.charAt(pos) == ':') {
            String host = s.substring(0, pos);
            int port = HostAndPortImpl.parsePort(s, pos);
            if (port == -1) {
                return null;
            }
            return new HostAndPortImpl(host, port);
        }
        return null;
    }

    private static int parsePort(String s, int pos) {
        int port = 0;
        while (++pos < s.length()) {
            int digit = HostAndPortImpl.parseDigit(s, pos, s.length());
            if (digit == -1) {
                return -1;
            }
            if ((port = port * 10 + digit) <= 65535) continue;
            return -1;
        }
        return port;
    }

    public HostAndPortImpl(String host, int port) {
        if (host == null) {
            throw new NullPointerException();
        }
        this.host = host;
        this.port = port;
    }

    @Override
    public String host() {
        return this.host;
    }

    @Override
    public int port() {
        return this.port;
    }

    public int hashCode() {
        return this.host.hashCode() ^ this.port;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof HostAndPort) {
            HostAndPort that = (HostAndPort)obj;
            return this.port == that.port() && this.host.equals(that.host());
        }
        return false;
    }

    public String toString() {
        if (this.port >= 0) {
            return this.host + ":" + this.port;
        }
        return this.host;
    }

    static {
        Arrays.fill(DIGITS, (byte)-1);
        for (int i = 48; i <= 57; ++i) {
            HostAndPortImpl.DIGITS[i] = (byte)(i - 48);
        }
    }
}

